/* #includes */ /*{{{C}}}*//*{{{*/
#include <errno.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <termios.h>
#include <unistd.h>

#include "setterm.h"
/*}}}*/

/* variables */ /*{{{*/
extern Terminal aixterm;
extern Terminal hft;
extern Terminal linux;
extern Terminal linux_m;
extern Terminal vt100;
extern Terminal wyse60;
extern Terminal xterm;
extern Terminal xwsh;

static Terminal *entry[]=
{
  &aixterm,
  &hft,
  &xwsh,
  &linux,
  &linux_m,
  &vt100,
  &wyse60,
  &xterm,
};  

static struct termios originalattr, cbreakattr;

FILE *tty;
/*}}}*/

void cooked(void) /*{{{*/
{
  tcsetattr(0,TCSADRAIN,&originalattr);
}
/*}}}*/
void cbreak(void) /*{{{*/
{
  tcsetattr(0,TCSADRAIN,&cbreakattr);
}
/*}}}*/

int main(int argc, char *argv[]) /*{{{*/
{
  char *term;
  int i,j,help=0,list=0,fd;

  if ((fd=dup(fileno(stdin)))==-1 || (tty=fdopen(fd,"w"))==(FILE*)0)
  {
    fprintf(stderr,"setterm: failed to reopen stdin: %s\n",strerror(errno));
    exit(2);
  }
  tcgetattr(0,&originalattr);
  cbreakattr=originalattr;
  cbreakattr.c_lflag&=~(ICANON|ECHO);
  term=getenv("TERM");
  if (argc>=3 && strcmp(argv[1],"-T")==0) { term=argv[2]; argv+=3; argc-=3; }
  else { ++argv; --argc; }
  if (argc>=1 && strcmp(*argv,"-h")==0) { help=1; --argc; ++argv; }
  else if (argc>=1 && strcmp(*argv,"-?")==0) { help=1; --argc; ++argv; }
  else if (argc>=1 && strcmp(*argv,"-l")==0) { list=1; --argc; ++argv; }
  else if (argc==0) help=1;
  
  if (list)
  {
    for (i=0; i<(sizeof(entry)/sizeof(entry[0])); ++i) 
    for (j=0; entry[i]->term[j]!=(char*)0; ++j) printf("%s\n",entry[i]->term[j]);
    return 0;
  }
  else for (j=0; j<(sizeof(entry)/sizeof(entry[0])); ++j)
  {
    for (i=0; entry[j]->term[i]!=(char*)0 && strcmp(term,entry[j]->term[i]); ++i);
    if (entry[j]->term[i]!=(char*)0)
    {
      if (help)
      {
        fprintf(stderr,"Usage: setterm [-T terminal] [-h|-l]");
        for (i=0; entry[j]->opt[i].opt!=(char*)0; ++i)
        {
          fprintf(stderr," [%s",entry[j]->opt[i].opt);
          if (entry[j]->opt[i].arg)
          {
            fprintf(stderr," %s",entry[j]->opt[i].arg);
            while (entry[j]->opt[i+1].opt && strcmp(entry[j]->opt[i].opt,entry[j]->opt[i+1].opt)==0)
            {
              ++i;
              fprintf(stderr,"|%s",entry[j]->opt[i].arg);
            }
          }
          fprintf(stderr,"]");
        }
        fprintf(stderr,"\n");
        return 1;
      }
      while (argc>0)
      {
        for (i=0; entry[j]->opt[i].opt!=(char*)0; ++i) 
        {
          if (strcmp(entry[j]->opt[i].opt,*argv)!=0) continue;
          if (entry[j]->opt[i].arg!=(char*)0)
          {
            if (argc<2) continue;
            if (strcmp(entry[j]->opt[i].arg,*(argv+1))!=0 && entry[j]->opt[i].str!=(char*)0) continue;
          }
          break;
        }    
        if (entry[j]->opt[i].opt!=(char*)0)
        {
          if (entry[j]->opt[i].str) fputs(entry[j]->opt[i].str,stdout);
          else (*entry[j]->opt[i].fun)(entry[j]->opt[i].arg!=(char*)0 ? *(argv+1) : (char*)0);
          --argc; ++argv;
          if (entry[j]->opt[i].arg!=(char*)0) { --argc; ++argv; }
        }
        else
        {
          fflush(stdout);
          fprintf(stderr,"setterm: No option %s for terminal %s\n",*argv,term);
          return 2;
        }
      }
      fflush(stdout);
      return 0;
    }
  }
  fprintf(stderr,"Usage: setterm [-T terminal] [-h|-l] option ...\n");
  return 1;
}
/*}}}*/
