/* #includes */ /*{{{C}}}*//*{{{*/
#include <stdio.h>

#include "setterm.h"
/*}}}*/

static void set_title(const char *arg)
{
  printf("\033]2;%s\007",arg);
}

static void set_icon(const char *arg)
{
  printf("\033]1;%s\007",arg);
}

static void set_font(const char *arg)
{
  printf("\033]50;%s\007",arg);
}

static void print_title(const char *arg)
{
  int c;

  cbreak();
  fprintf(tty,"\033[21t"); fflush(tty);
  if (getchar()=='\033')
  {
    if (getchar()==']')
    {
      if (getchar()=='l')
      {
        while ((c=getchar())!=EOF && c!='\033') putchar(c);
        getchar();
        putchar('\n');
      }
    }
  }
  cooked();
}

static void get_cursory(const char *arg)
{
  char posn[10];
  int i = 0;
  
  cbreak();
  fprintf(tty,"\033[6n"); fflush(tty);
  for (i=0; i<(sizeof(posn)-1) && ((posn[i] = getchar()) != ';'); i++);
  posn[i] = '\0';
  if (i>2) printf("%s\n",posn+2); fflush(stdout);
  cooked();
}

static void get_cursorx(const char *arg)
{
  char posn[14];
  int i = 0;
  
  cbreak();
  fprintf(tty,"\033[6n"); fflush(tty);
  for (i=0; i<(sizeof(posn)-1) && ((posn[i] = getchar()) != 'R'); i++);
  posn[i] = '\0';
  if (i>2) printf("%s\n",posn+5); fflush(stdout);
  cooked();
}

static Name names[]=
{
  "xterm",
  "xterm-color",
  (const char*)0
};

static Option opts[]=
{
  { "-title", "Title", (const char*)0, set_title },
  { "-icon", "Title", (const char*)0, set_icon },
  { "-fn", "Font", (const char*)0, set_font },
  { "-scroll", "smooth", "\033[?4h", (void(*)(const char*))0 },
  { "-scroll", "jump", "\033[?4l", (void(*)(const char*))0 },
  { "-linewrap", "on", "\033[?7h", (void(*)(const char*))0 },
  { "-linewrap", "off", "\033[?7l", (void(*)(const char*))0 },
  { "-inversescreen", "on", "\033[?5h", (void(*)(const char*))0 },
  { "-inversescreen", "off", "\033[?5l", (void(*)(const char*))0 },
  { "-printtitle", (const char*)0, (const char*)0, print_title },
  { "-getcursory", (const char*)0, (const char*)0, get_cursory },
  { "-getcursorx", (const char*)0, (const char*)0, get_cursorx },
  { (const char*)0, (const char*)0, (const char*)0, (void(*)(const char*))0 },
};

Terminal xterm = { names, opts };
