#!/bin/sh
#
# This software is subject to the terms of the IBM Public License.
# You must accept the terms of this license to use this software.
#
#  Copyright (C) 2000, International Business Machines Corporation
# and others.  All Rights Reserved.
#

VERSION=1.0
BINDIR=`dirname $0`
PKGDIR=${BINDIR%/*}
WORKDIR=

RUNTEST=runtest.sh
MODULES="coll iconv iswc lang mbstowcs mbtowc printf string"

binary_check ()
{
  ls $PKGDIR/coll/test_coll > /dev/null 2>&1
  if [ $? -ne 0 ] ; then
    echo "You should type \`make' to create all binaries before running this tool."
    exit 1
  fi
}

lang_set ()
{
  echo -n "enter locale ? "
  read new
  export LANG=$new
  echo "locale set. ($LANG)"
  PS3="Select item [1-12] ($LANG) ? "
  export LANG
}

lang_check ()
{
  if [ z$LANG = z ] ; then
    echo " LANG isn't set yet. "
    lang_set
  fi
}

pager_check ()
{
  if [ z$PAGER = z ] ; then
    echo " PAGER isn't set yet. "
    echo -n "enter pager (default less) ? "
    read new
    export PAGER=${new:-less}
    echo "PAGER set to $PAGER"
    export PAGER
  fi
}

show_banner ()
{
 echo ""
 echo "-------- GLIBCTEST $VERSION ---------"
 echo ""
}

test_module ()
{
  echo ""
  echo "TESTING $1"
 ( \
   cd $PKGDIR/$1 ; sh $RUNTEST ; \
   echo -n "See log [y/N]? " ; \
   read ans ;\
   if [ z$ans = zy -o z$ans = zY ] ; then $PAGER log.${LANG%.*}* ; fi \
 )
 echo "END OF TEST $1"
 echo "----- PRESS ENTER -----"
 read ans
 show_banner
}

manual_page ()
{
  echo ""
  echo "Enter module name"
  echo -n "($MODULES) ? "
  read ans
  if test x$ans != x ; then
    man -M $PKGDIR/man test_$ans
  fi
}

# MAIN

binary_check

show_banner

lang_check
#pager_check

PS3="Select item [1-12] ($LANG) ? "
PAGER=more

# infinite loop
select ANS in \
"test collation (strcoll, wcscoll)" \
"test iconv function" \
"test iswcxxx functions (e.g., iswcalpha)" \
"test lang functions (e.g., nl_langinfo )" \
"test mbstowcs functions" \
"test mbtowc functions" \
"test printf functions" \
"test string functions" \
"test all above" \
"set test locale" \
"see manual pages" \
"quit"
do
 case "$REPLY" in
    1)
      test_module coll
      ;;
    2)
      test_module iconv
      ;;
    3)
      test_module iswc
      ;;
    4)
      test_module lang
      ;;
    5)
      test_module mbstowcs
      ;;
    6)
      test_module mbtowc
      ;;
    7)
      test_module printf
      ;;
    8)
      test_module string
      ;;
    9)
      for dir in $MODULES
      do
        test_module $dir
      done
      ;;
   10)
      lang_set
      ;;
   11)
      manual_page
      ;;
   12|q)
      exit 0
      ;;
esac
done
