/*
 *
 * This software is subject to the terms of the IBM Public License.
 * You must accept the terms of this license to use this software.
 *
 *  Copyright (C) 2000, International Business Machines Corporation
 * and others.  All Rights Reserved.
 *
 *  Version : 1.0 (2000-07-19)
 *
 *  Author  :   Tadayuki Yoshida <tadayuki@jp.ibm.com>
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>

#include "glibctest.h"
#include "test_coll.h"

/*
 *
 * int getparams ( int argc, char **argv, params *paramp )
 *
 */

int
getparams_coll (int argc, char *argv[], params * paramp)
{
  int opt;
  boolean interactive = false;
  char *answer_file;

  paramp->genans_global = false;
  paramp->prompt_flag = false;
  paramp->verbose_flag = true;
  paramp->input_fp = (FILE *) NULL;
  paramp->ans_fp = (FILE *) NULL;

  answer_file = (char *) NULL;

  while ((opt = getopt (argc, argv, "f:ghvsl")) != -1)
    {
      switch (opt)
	{
	case 'f':
	  {
	    interactive = false;
	    stringpcpy (&answer_file, optarg);
	    break;
	  }
	case 'g':
	  {
	    paramp->genans_global = true;
	    break;
	  }
	case 'h':
	  {
	    print_help_coll ();
	    exit (0);
	    break;
	  }
	case 'v':
	  {
	    paramp->verbose_flag = true;
	    break;
	  }
	case 's':
	  {
	    paramp->verbose_flag = false;
	    break;
	  }
	case 'l':
	  {
	    print_supported_API ();
	    exit (0);
	    break;
	  }
	case '?':
	  {
	    fprintf (stderr, "unknown option %c\n", opt);
	    break;
	  }
	}
    }

  if (interactive)
    {
      paramp->ans_fp = stdin;
    }
  else if (answer_file)
    {
      paramp->ans_fp = fopen (answer_file, "r");
      if (NULL == paramp->ans_fp)
	{
	  fprintf (stderr, "could not open file: %s \n", answer_file);
          mem_free ((void *) answer_file);
	  exit (1);
	}
      mem_free ((void *) answer_file);
    }
  else
    {
      fprintf (stderr, "No answer file was specified.\n");
      exit (1);
    }

  return (optind);
}
