/*
 *
 * This software is subject to the terms of the IBM Public License.
 * You must accept the terms of this license to use this software.
 *
 *  Copyright (C) 2000, International Business Machines Corporation
 * and others.  All Rights Reserved.
 *
 *  Version : 1.0 (2000-07-19)
 *
 *  Author  :   Tadayuki Yoshida <tadayuki@jp.ibm.com>
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

/*
 *
 * void string_sort ( char **a, size_t n )
 *
 * Sort a list including 'n' strings.
 * Each string has multibyte characters.
 *
 * arguments:
 *   char ** a ; target array of string
 *   int     n ; length of array 'a'
 *
 * return   : void
 *
 */

void
string_sort (char **a, size_t n)
{
  int i, j;
  char *x, *w;

  do
    {
      i = 0;
      j = n - 1;
      x = a[j / 2];
      do
	{
	  while (strcoll (a[i], x) < 0)
	    i++;
	  while (strcoll (a[j], x) > 0)
	    j--;
	  if (i < j)
	    {
	      w = a[i];
	      a[i] = a[j];
	      a[j] = w;
	    }
	}
      while (++i <= --j);

      if (i == j + 3)
	{
	  --i;
	  ++j;
	}
      if (j + 1 < n - i)
	{
	  if (j > 0)
	    string_sort (a, j + 1);
	  a += i;
	  n -= i;
	}
      else
	{
	  if (i < n - 1)
	    string_sort (a + i, n - i);
	  n = j + 1;
	}
    }
  while (n > 1);

}

/*
 *
 * void wstring_sort ( wchar_t **a, size_t n )
 *
 * Sort a list including 'n' strings.
 * Each string has wide characters.
 *
 * arguments:
 *  wchar_t ** a ; target array of string
 *  int        n ; length of array a
 *
 * return   : void
 *
 */

void
wstring_sort (wchar_t ** a, size_t n)
{
  int i, j;
  wchar_t *x, *w;

  do
    {
      i = 0;
      j = n - 1;
      x = a[j / 2];
      do
	{
	  while (wcscoll (a[i], x) < 0)
	    i++;
	  while (wcscoll (a[j], x) > 0)
	    j--;
	  if (i < j)
	    {
	      w = a[i];
	      a[i] = a[j];
	      a[j] = w;
	    }
	}
      while (++i <= --j);

      if (i == j + 3)
	{
	  --i;
	  ++j;
	}
      if (j + 1 < n - i)
	{
	  if (j > 0)
	    wstring_sort (a, j + 1);
	  a += i;
	  n -= i;
	}
      else
	{
	  if (i < n - 1)
	    wstring_sort (a + i, n - i);
	  n = j + 1;
	}
    }
  while (n > 1);

}
