/*
 *
 * This software is subject to the terms of the IBM Public License.
 * You must accept the terms of this license to use this software.
 *
 *  Copyright (C) 2000, International Business Machines Corporation
 * and others.  All Rights Reserved.
 *
 *  Version : 1.0 (2000-07-19)
 *
 *  Author  :   Tadayuki Yoshida <tadayuki@jp.ibm.com>
 *
 */

#include "glibctest.h"
#include "test_iconv.h"

supported_API apilist[] = {
  {"size_t iconv ( iconv_t, const char *, size_t *, char **, size_t * )",
   "perform character set conversion."},
  {"iconv_t iconv_open ( const char *, const char * )",
   "allocate desciptor for character set conversion."},
  {"int iconv_close ( iconv_t )",
   "deallocate descriptor for character set conversion."},
  {"\0", "\0"}
};

char *
get_oneline_iconv_mbs ( FILE *fp, char **bufp, int *lengthp )
{
  int unit = 1;
  char c;
  char sol[] = "<SOL>";
  char eol[] = "<EOL>";
  fpos_t datastart;
  int flag;
  int cnt;
  size_t ret;
  int datacount;

  ret = fread ((void *)&c, unit, 1, fp);

  /* find <SOL> */
  while (true)
    {
      /* skip until '<' appear */
      while ( c != sol[0] )
	{
	  if (feof (fp)) return NULL;
	  else if (ferror (fp)) return NULL;
	  else ret = fread ((void *)&c, unit, 1, fp);
	}

      flag = 1;
      cnt = 1;
      while ( cnt < 5 )
	{
	  if (feof (fp)) return NULL;
	  else if (ferror (fp)) return NULL;
	  else
	    {
	      ret = fread ((void *)&c, unit, 1, fp);
	      if ( c == sol[cnt] )
		{
		  cnt += 1;
		}
	      else
		{
		  flag = 0;
		  break;
		}
	    }
	}
      if (flag == 1) /* scanned <SOL> */
	{
	  fgetpos (fp, &datastart);
	  break;
	}
      else
	{
	  continue;
	}
    }

  datacount = -1;
  /* find <EOL> */
  while (true)
    {
      /* skip until '<' appear */
      while ( c != eol[0] )
	{
	  datacount += unit;
	  if (feof (fp)) return NULL;
	  else if (ferror (fp)) return NULL;
	  else ret = fread ((void *)&c, unit, 1, fp);
	}

      flag = 1;
      cnt = 1;
      while ( cnt < 5 )
	{
	  if (feof (fp)) return NULL;
	  else if (ferror (fp)) return NULL;
	  else
	    {
	      ret = fread ((void *)&c, unit, 1, fp);
	      if ( c == eol[cnt] )
		{
		  cnt += 1;
		}
	      else
		{
		  flag = 0;
		  break;
		}
	    }
	}
      if (flag == 1) /* scanned <EOL> */
	{
	  break;
	}
      else
	{
	  continue;
	}
    }

  *bufp = (char *) mem_alloc (datacount * sizeof (char));
  fsetpos (fp, &datastart);

  fread ((void *)*bufp, datacount, 1, fp);
  *lengthp = datacount;

  return (*bufp);
}

char *
get_oneline_iconv_ucs ( FILE *fp, char **bufp, int *lengthp )
{
  int unit = 2;
  char c[2] = {0xff, 0xff};
  char sol[10] = SOL;
  char eol[10] = EOL;
  fpos_t datastart;
  int flag;
  int cnt;
  size_t ret;
  int datacount;

  ret = fread ((void *)c, unit, 1, fp);

  /* find <SOL> */
  while (true)
    {
      /* skip until '<' appear */
      while ( !((c[0] == sol[0]) && (c[1] == sol[1])) )
	{
	  if (feof (fp)) return NULL;
	  else if (ferror (fp)) return NULL;
	  else ret = fread ((void *)c, unit, 1, fp);
	}

      flag = 1;
      cnt = 2;
      while ( cnt < 10 )
	{
	  if (feof (fp)) return NULL;
	  else if (ferror (fp)) return NULL;
	  else
	    {
	      ret = fread ((void *)c, unit, 1, fp);
	      if ( (c[0] == sol[cnt]) && (c[1] == sol[cnt+1]) )
		{
		  cnt += 2;
		}
	      else
		{
		  flag = 0;
		  break;
		}
	    }
	}
      if (flag == 1) /* scanned <SOL> */
	{
	  fgetpos (fp, &datastart);
	  break;
	}
      else
	{
	  continue;
	}
    }

  datacount = -2;
  /* find <EOL> */
  while (true)
    {
      /* skip until '<' appear */
      while ( !((c[0] == eol[0]) && (c[1] == eol[1])) )
	{
	  if (feof (fp)) return NULL;
	  else if (ferror (fp)) return NULL;
	  else ret = fread ((void *)c, unit, 1, fp);
	  datacount += unit;
	}

      flag = 1;
      cnt = 2;
      while ( cnt < 10 )
	{
	  if (feof (fp)) return NULL;
	  else if (ferror (fp)) return NULL;
	  else
	    {
	      ret = fread ((void *)c, unit, 1, fp);
	      if ( (c[0] == eol[cnt]) && (c[1] == eol[cnt+1]) )
		{
		  cnt += 2;
		}
	      else
		{
		  flag = 0;
		  break;
		}
	    }
	}
      if (flag == 1) /* scanned <EOL> */
	{
	  break;
	}
      else
	{
	  continue;
	}
    }

  *bufp = (char *) mem_alloc (datacount * sizeof (char));
  fsetpos (fp, &datastart);

  fread ((void *)*bufp, datacount, 1, fp);

  *lengthp = datacount;

  return (*bufp);
}

int
main (int argc, char **argv)
{
  iconv_t converter;
  size_t status;
  char *inbuf, *outbuf, *ansbuf;
  char *ret;
  char *outcode;
  char *anscode;
  char *fromcode, *tocode;
  char *inbufp, *outbufp, *ansbufp;
  char tmpcode[3] = {'\0', '\0', '\0'};
  char sol[] = SOL;
  char eol[] = EOL;
  char retstr[] = RET;
  int opt;
  boolean result;
  int error_cnt, case_cnt;
  int fromdatatype, todatatype;
  int length;
  int i;

  params prm;

  size_t inbytesleft;
  size_t outbytesleft;

  system_info ();

  /*
#if __BYTE_ORDER == __BIG_ENDIAN
  printf ("Big Endian\n");
#else
  printf ("Little Endian\n");
#endif
  */

  /*
   * Option Check
   */

  if (argc == 2 && stringeq (argv[1], "-h"))
    {
      print_help_iconv ();
      exit (0);
    }
  opt = getparams_iconv (argc, argv, &prm);

  if ((prm.input_fp == NULL) || (!prm.genans_global && (prm.ans_fp == NULL)))
    {
      fprintf (stderr,
	       "You must specify both of inputfile (-f) and answerfile (-a).\n");
      exit (-1);
    }

  if (opt + 2 > argc)
    {
      fprintf (stderr,
	       "You must specify both of inputcode and outputcode.\n");
      exit (-1);
    }

  stringpcpy (&fromcode, argv[opt]);
  stringpcpy (&tocode, argv[opt+1]);
  fromdatatype  = substring (fromcode, "UCS") ? UCSDATA : OTHERS;
  todatatype = substring (tocode, "UCS") ? UCSDATA : OTHERS;

  converter = iconv_open (tocode, fromcode);

  mem_free ((void *)fromcode);
  mem_free ((void *)tocode);

  if ((iconv_t) (-1) == converter)
    {
      perror ("Error: iconv_open");
      exit (1);
    }

  error_cnt = 0;
  case_cnt = 0;

  while (true)
    {
      if (fromdatatype == UCSDATA)
	{
	  ret = get_oneline_iconv_ucs (prm.input_fp, &inbuf, &length);
	}
      else
	{
	  ret = get_oneline_iconv_mbs (prm.input_fp, &inbuf, &length);
	}
      if (ret == NULL) break;
      inbytesleft = length;
      inbufp = inbuf;

      outbytesleft = 1024;
      outbuf = (char *) mem_alloc (outbytesleft * sizeof (char));
      outbufp = outbuf;

      status =
	iconv (converter, (const char **) &inbuf, &inbytesleft, &outbuf, &outbytesleft);

      if (status == (size_t) (-1))
	{
	  perror ("Error: iconv_main");
	}

      mem_free ((void *) inbufp);

      if (!prm.genans_global) /* normal mode */
	{
	  if (todatatype == UCSDATA)
	    {
	      ret = get_oneline_iconv_ucs (prm.ans_fp, &ansbuf, &length);
	    }
	  else
	    {
	      ret = get_oneline_iconv_mbs (prm.ans_fp, &ansbuf, &length);
	    }
	  if (ret == NULL) break;

	  ansbufp = ansbuf;
	  outcode = (char *) mem_alloc ((length*2+1) * sizeof (char));
	  anscode = (char *) mem_alloc ((length*2+1) * sizeof (char));
	  outcode[0] = '\0';
	  anscode[0] = '\0';
	  /* check */
	  result = true;
	  for (i=0; i < length ; i++)
	    {
	      sprintf (tmpcode, "%02x", (unsigned char)outbufp[i]);
	      stringcat (outcode, tmpcode);
	      sprintf (tmpcode, "%02x", (unsigned char)ansbuf[i]);
	      stringcat (anscode, tmpcode);
	      result &= (outbufp[i] == ansbuf[i]);
	    }
	  display ("iconv", outcode, anscode, result,
		       prm.genans_global, prm.verbose_flag);
	  error_cnt += !result;
	  case_cnt++;
	  mem_free ((void *)outcode);
	  mem_free ((void *)anscode);
	  mem_free ((void *)ansbufp);
	}
      else /* generate answer mode */
	{
	  length = 1024 - outbytesleft;
	  if (todatatype == UCSDATA)
	    {
	      fwrite (sol, 10, 1, stdout);
	    }
	  else
	    {
	      fwrite ("<SOL>", 5, 1, stdout);
	    }
	  fwrite (outbufp, length, 1, stdout);
	  if (todatatype == UCSDATA)
	    {
	      fwrite (eol, 10, 1, stdout);
	      fwrite (retstr, 2, 1, stdout);
	    }
	  else
	    {
	      fwrite ("<EOL>", 5, 1, stdout);
	      fwrite ("\n", 1, 1, stdout);
	    }
	  /*
	  display ("iconv", outbuf, "", true, prm.genans_global,
		   prm.verbose_flag);
	  */
	}
      mem_free ((void *) outbufp);
    }

  if (!prm.genans_global)
    {
      result_report (case_cnt, error_cnt, "");
    }

  iconv_close (converter);

  return (0);
}
