/*
 *
 * This software is subject to the terms of the IBM Public License.
 * You must accept the terms of this license to use this software.
 *
 *  Copyright (C) 2000, International Business Machines Corporation
 * and others.  All Rights Reserved. 
 *
 *  Version : 1.0 (2000-07-19)
 *
 *  Author  :   Tadayuki Yoshida <tadayuki@jp.ibm.com>
 *
 */

#ifndef _WCHAR_H
#include <wchar.h>
#endif

#include "config.h"
#include "boolean.h"
#include "hash.h"

#ifndef _STDIO_H
#include <stdio.h>
#endif

#define MAX_LINE_LEN 256
#define MAX_API_LEN 128
#define PARAM_NUM 3

#define TESTING_THE_API_IS_NOT_SUPPORTED    2000

#define EMPTYLINE 100
#define INSUFFICIENTLINE 101
#define READSUCCESS 102

#define SUCCSTR "[ OK ]"
#define FAILSTR "[FAIL]"
#define OOPSSTR "[OOPS]"

#define COPYRIGHT_FORM "\n\
 This software is subject to the terms of the IBM Public License.\n\
 You must accept the terms of this license to use this software.\n\
 \n\
  Copyright (C) 2000, International Business Machines Corporation\n\
 and others.  All Rights Reserved.\n"

typedef struct {
  char *api_name;
  char *param[PARAM_NUM];
  char *result;
} answer;

typedef struct {
  wchar_t *api_name;
  wchar_t *param[PARAM_NUM];
  wchar_t *result;
} wc_answer;

typedef struct {
  FILE *input_fp;
  FILE *ans_fp;
  /*  FILE *out_fp; */
  boolean prompt_flag;
  boolean genans_global;
  boolean verbose_flag;
} params;

typedef struct _supported_API {
  char api[MAX_API_LEN];
  char comment[MAX_LINE_LEN];
} supported_API;

typedef struct _api_table {
  hashtable *tablep;
} api_table;

typedef boolean (*apitest_t) ( answer *, wc_answer *, boolean, boolean );
  
extern size_t stringlen ( const char * );
extern char * stringcat ( char *, const char * );
extern char * stringcpy ( char *, const char * );
extern char * stringpcpy ( char **, const char * );
extern boolean stringeq ( const char *, const char * );
extern boolean stringeqn ( const char *, const char *, size_t );
extern boolean substring ( const char *, const char * );
extern int lformat2wcs ( wchar_t *, const char * );
extern boolean wstringeq ( const wchar_t *, const wchar_t * );
extern boolean wstringeqn ( const wchar_t *, const wchar_t *, size_t );
extern wchar_t * wstringcpy ( wchar_t *, const wchar_t * );
extern wchar_t * wstringcat ( wchar_t *, const wchar_t * );

extern boolean test_apis ( answer *, wc_answer *, boolean, boolean );

extern void * mem_alloc ( size_t );
extern void * mem_calloc ( size_t, size_t );
extern int xstr2ul ( char *, char * );
extern int ul2xstr ( char *, char * );
extern void display_result ( answer *, char *, char *, char *, boolean, boolean, boolean );
extern void display_verbose ( char *, char *, char *, boolean );
extern void display ( char *, char *, char *, boolean, boolean, boolean );
extern void display_string ( char * );
extern void display_progress ( int, int );
extern void print_prompt ( params * );
extern void convert_mbswcs ( wchar_t **, char * );
extern void convert_wcsmbs ( char **, wchar_t * );
extern void print_header ( char * );
extern void print_comment ( char * );
extern void print_supported_API ( void );
extern void print_help ( char * );
extern int print_format_help ( char * );
extern void result_report ( int, int, char * );
extern char * get_oneline ( FILE *, char ** );
extern char * fgetstr ( char *, int, FILE * );
/* extern void test_case_init ( char **, answer * ); */
/* extern void string_init ( char **, size_t ); */

extern boolean iscommentline ( char *, char );
extern boolean ishexdigit  ( char );
extern boolean isnormaldigit ( char );
extern boolean isoctaldigit ( char );
extern boolean iswhitespace ( char );
extern size_t count_digit ( int );
extern int count_param ( char * );

extern int system_info ( void );

extern int input_reader ( FILE *, answer *, wc_answer *, boolean * );
extern void replace_tag_to_char ( char *, char ** );
extern void replace_char_to_tag ( char **, char * );
extern char * set_token_from_buf ( char *, char ** );
extern int getparams ( int, char **, params *, char * );

extern supported_API apilist[];
extern void extract_realkey ( char **, const char *, const char );

/* API Register */
extern api_table * api_table_init ( const int );
extern void api_table_free ( api_table * );
extern void api_table_add ( const api_table *, const char *, apitest_t );
extern boolean api_table_select ( api_table *, answer *, wc_answer *, boolean, boolean );
extern void api_table_create ( const api_table * );
