/*
 *
 * This software is subject to the terms of the IBM Public License.
 * You must accept the terms of this license to use this software.
 *
 *  Copyright (C) 2000, International Business Machines Corporation
 * and others.  All Rights Reserved.
 *
 *  Version : 1.0 (2000-07-19)
 *
 *  Author  :   Tadayuki Yoshida <tadayuki@jp.ibm.com>
 *
 */

#ifndef _INDEXEDLIST_H_
#define _INDEXEDLIST_H_

#include <stdio.h>

typedef struct _indexedlist_data {
  void *datap;
} indexedlist_data;

typedef struct _indexedlist {
  indexedlist_data *listp;
  int total_num;
  void (*data_display) ( void * );
  void (*data_free) ( void * );
} indexedlist;

extern indexedlist * indexedlist_init ( const int, void (*) ( void * ), void (*) ( void * ) );
extern void indexedlist_add ( const indexedlist *, const int, void * );
extern void * indexedlist_search ( const indexedlist *, const int );
extern void indexedlist_free ( indexedlist * );
extern void indexedlist_display ( const indexedlist * );
extern void indexedlist_data_free ( const void * );
extern void indexedlist_data_display ( const void * );
extern int end_of_indexedlist ( const indexedlist *, const int );
extern int indexedlist_get_total_num ( const indexedlist * );

#endif
