/*
 *
 * This software is subject to the terms of the IBM Public License.
 * You must accept the terms of this license to use this software.
 *
 *  Copyright (C) 2000, International Business Machines Corporation
 * and others.  All Rights Reserved.
 *
 *  Version : 1.0 (2000-07-19)
 *
 *  Author  :   Tadayuki Yoshida <tadayuki@jp.ibm.com>
 *
 */
#include "glibctest.h"
#include "test_iswc.h"
#include "lcctype.h"

int
insert_file (FILE * fp, FILE * tmpfp)
{
  int i, j, tmp, end;
  char *bufp;
  char *copyfilename;
  char *copyfilelongname;
  FILE *copyfp;

  /* skip until read "LC_CTYPE" */
  while (NULL != get_oneline (fp, &bufp))
    {
      if (stringeqn (bufp, "LC_CTYPE", 8))
	{
	  mem_free ((void *) bufp);
	  break;
	}
      mem_free ((void *) bufp);
    }

  while (NULL != get_oneline (fp, &bufp))
    {
      if (stringeqn (bufp, "copy", 4))
	{
	  i = 0;
	  while (*(bufp+i) != '"')
	    {
	      i++;
	    }

	  tmp = ++i;
	  while (*(bufp+i) != '"')
	    {
	      i++;
	    }
	  end = i;
	  copyfilename = (char *) mem_alloc (sizeof (char) * (end - tmp + 1));
	  for (i=tmp, j=0; i <end; i++, j++)
	    {
	fprintf (stderr, "char = [%c]\n", bufp[i]);
	      copyfilename[j] = bufp[i];
	    }
	  copyfilename[j] = (char) NULL;
	  copyfilelongname = (char *) mem_alloc (sizeof (char) * (stringlen (copyfilename) + stringlen (LOCALEDIR) +1));
	  stringcpy (copyfilelongname, LOCALEDIR);
	  stringcat (copyfilelongname, copyfilename);
	  if (NULL == (copyfp = fopen (copyfilelongname, "r")))
	    {
	      fprintf (stderr, "file %s not found.\n", copyfilelongname);
	      exit (1);
	    }
	  mem_free ((void *) copyfilename);
	  mem_free ((void *) copyfilelongname);
	  insert_file (copyfp, tmpfp);
	  fclose (copyfp);
	}
      else
	{
	  if (stringeqn (bufp, "END LC_CTYPE", 12))
	    {
	      mem_free ((void *) bufp);
	      break;
	    }
	  fputs (bufp, tmpfp);
	  fputs ("\n", tmpfp);
	}
      mem_free ((void *) bufp);
    }
}

void
file_process ( FILE *fp )
{
  FILE *tmpfp;
  char *bufp;

  if (NULL == (tmpfp = fopen (TMPFILE, "w")))
    {
      fprintf (stderr, "file ");
      fprintf (stderr, TMPFILE);
      fprintf (stderr, " can't open.\n");
      exit (1);
    }

  while (NULL != get_oneline (fp, &bufp))
    {
      fputs (bufp, tmpfp);
      fputs ("\n", tmpfp);
      if (stringeqn (bufp, "LC_CTYPE", 8))
	{
	  mem_free ((void *) bufp);
	  break;
	}
      mem_free ((void *) bufp);
    }
  rewind (fp);
  insert_file (fp, tmpfp);
  fputs ("END LC_CTYPE", tmpfp);
  fputs ("\n", tmpfp);

  fclose (tmpfp);
}
