/*
 *
 * This software is subject to the terms of the IBM Public License.
 * You must accept the terms of this license to use this software.
 *
 *  Copyright (C) 2000, International Business Machines Corporation
 * and others.  All Rights Reserved.
 *
 *  Version : 1.0 (2000-07-19)
 *
 *  Author  :   Tadayuki Yoshida <tadayuki@jp.ibm.com>
 *
 */
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>

#include "glibctest.h"
#include "test_iswc.h"
#include "lcctype.h"
#include "charmap.h"

/***********************************************************
*                                                          *
* int getparams ( int argc,                                *
*                 char **argv,                             *
*                 params *paramp )                         *
*                                                          *
************************************************************/

int
getparams_iswc (int argc, char *argv[], params * paramp)
{
  int opt;
  boolean interactive = true;
  char *locale_file;
  char *charmap_file;

  paramp->genans_global = false;
  paramp->prompt_flag = false;
  paramp->verbose_flag = true;
  paramp->input_fp = (FILE *) NULL;
  paramp->ans_fp   = (FILE *) NULL;

  locale_file  = (char *) NULL;
  charmap_file = (char *) NULL;

  while ((opt = getopt (argc, argv, "if:a:ghpvsl")) != -1)
    {
      switch (opt)
	{
	case 'i':
	  {
	    interactive = true;
	    break;
	  }
	case 'f':
	  {
	    interactive = false;
	    stringpcpy (&locale_file, optarg);
	    break;
	  }
	case 'a':
	  {
	    stringpcpy (&charmap_file, optarg);
	    break;
	  }
	case 'g':
	  {
	    paramp->genans_global = true;
	    break;
	  }
	case 'h':
	  {
	    print_help_iswc ();
	    exit (0);
	    break;
	  }
	case 'p':
	  {
	    paramp->prompt_flag = true;
	    break;
	  }
	case 'v':
	  {
	    paramp->verbose_flag = true;
	    break;
	  }
	case 's':
	  {
	    paramp->verbose_flag = false;
	    break;
	  }
	case 'l':
	  {
	    print_supported_API ();
	    exit (0);
	    break;
	  }
	case '?':
	  {
	    fprintf (stderr, "unknown option %c\n", opt);
	    break;
	  }
	}
    }

  if (interactive)
    {
      paramp->input_fp = stdin;
    }
  else if (locale_file)
    {
      if (NULL == (paramp->input_fp = fopen (locale_file, "r")))
	{
	  fprintf (stderr, "could not open file: %s \n", locale_file);
          mem_free ((void *) locale_file);
	  exit (1);
	}
      mem_free ((void *) locale_file);
    }
  else
    {
      fprintf (stderr, "No input file was specified.\n");
      exit (1);
    }


  if (charmap_file)
    {
      if (NULL == (paramp->ans_fp = fopen (charmap_file, "r")))
	{
	  fprintf (stderr, "could not open file: %s \n", charmap_file);
          mem_free ((void *) charmap_file);
	  exit (1);
	}
      mem_free ((void *) charmap_file);
    }

  return (optind);
}
