/*
 *
 * This software is subject to the terms of the IBM Public License.
 * You must accept the terms of this license to use this software.
 *
 *  Copyright (C) 2000, International Business Machines Corporation
 * and others.  All Rights Reserved.
 *
 *  Version : 1.0 (2000-07-19)
 *
 *  Author  :   Tadayuki Yoshida <tadayuki@jp.ibm.com>
 *
 */
#include "glibctest.h"
#include "test_iswc.h"

static boolean iswupper_test ( answer *, wc_answer *, boolean, boolean );
static boolean iswlower_test ( answer *, wc_answer *, boolean, boolean );
static boolean iswalpha_test ( answer *, wc_answer *, boolean, boolean );
static boolean iswdigit_test ( answer *, wc_answer *, boolean, boolean );
static boolean iswalnum_test ( answer *, wc_answer *, boolean, boolean );
static boolean iswxdigit_test ( answer *, wc_answer *, boolean, boolean );
#ifdef HAVE_ISWBLANK
static boolean iswblank_test ( answer *, wc_answer *, boolean, boolean );
#endif
static boolean iswspace_test ( answer *, wc_answer *, boolean, boolean );
static boolean iswcntrl_test ( answer *, wc_answer *, boolean, boolean );
static boolean iswpunct_test ( answer *, wc_answer *, boolean, boolean );
static boolean iswgraph_test ( answer *, wc_answer *, boolean, boolean );
static boolean iswprint_test ( answer *, wc_answer *, boolean, boolean );
static boolean iswctype_test ( answer *, wc_answer *, boolean, boolean );
static boolean towupper_test ( answer *, wc_answer *, boolean, boolean );
static boolean towlower_test ( answer *, wc_answer *, boolean, boolean );
static boolean towctrans_test ( answer *, wc_answer *, boolean, boolean );

void
api_table_create ( const api_table *tp )
{
  api_table_add (tp, "iswupper", iswupper_test);
  api_table_add (tp, "iswlower", iswlower_test);
  api_table_add (tp, "iswalpha", iswalpha_test);
  api_table_add (tp, "iswdigit", iswdigit_test);
  api_table_add (tp, "iswalnum", iswalnum_test);
  api_table_add (tp, "iswxdigit", iswxdigit_test);
#ifdef HAVE_ISWBLANK
  api_table_add (tp, "iswblank", iswblank_test);
#endif
  api_table_add (tp, "iswspace", iswspace_test);
  api_table_add (tp, "iswcntrl", iswcntrl_test);
  api_table_add (tp, "iswpunct", iswpunct_test);
  api_table_add (tp, "iswgraph", iswgraph_test);
  api_table_add (tp, "iswprint", iswprint_test);
  api_table_add (tp, "iswctype", iswctype_test);
  api_table_add (tp, "towupper", towupper_test);
  api_table_add (tp, "towlower", towlower_test);
  api_table_add (tp, "towctrans", towctrans_test);
}

/**********************************************************************
*                                                                     *
*                          INTERACTIVE MODE                           *
*                                                                     *
***********************************************************************/

static boolean
check_result ( char *system, char *expected )
{
  boolean ret;

  if ( stringeq (system, expected) )
    {
      ret = true;
    }
  else if ( stringeq (system, "0") && stringeq (expected, "0") )
    {
      ret = true;
    }
  else if ( !stringeq (system, "0") && stringeq (expected, "!0") )
    {
      ret = true;
    }
  else
    {
      ret = false;
    }

  return (ret);
}

static void
set_testcase ( answer * ansp, int num, char **test_casep )
{
  size_t tmpsize;
  size_t padding = 10 + MB_LEN_MAX;
  char code[MB_LEN_MAX+1];

  tmpsize = stringlen (ansp->api_name) + stringlen (ansp->param[0]) + stringlen (ansp->param[1]) + stringlen (ansp->param[2]) + padding;
  *test_casep = (char *) mem_alloc (tmpsize * sizeof (char));

  ul2xstr (ansp->param[0], code);

  switch (num)
    {
    case 1:
      sprintf (*test_casep, "%s(%s[x%s])", ansp->api_name, ansp->param[0], code);
      break;

    case 2:
      sprintf (*test_casep, "%s(%s[x%s],%s)", ansp->api_name, ansp->param[0], code, ansp->param[1]);
      break;

    case 3:
      sprintf (*test_casep, "%s(%s[x%s],%s,%s)", ansp->api_name, ansp->param[0], code, ansp->param[1], ansp->param[2]);
      break;

    default :
      break;
    }
}

static void
set_retvalstr ( int retval, char **retstrp )
{
  size_t tmpsize;

  tmpsize = count_digit (retval) + 1;
  *retstrp = (char *) mem_calloc (tmpsize, sizeof (char));
  sprintf (*retstrp, "%d", retval);
}

static void
set_retvalstr_lc ( int retval, char **retstrp )
{
  size_t tmpsize;

  tmpsize = count_digit (retval) + 1;
  *retstrp = (char *) mem_calloc (tmpsize, sizeof (char));
  sprintf (*retstrp, "%lc", retval);
}

/******************************************
 * TEST: int  iswupper ( wint_t wc )      *
 ******************************************/
boolean
iswupper_test ( answer * ansp,
		wc_answer * wc_ansp,
		boolean genans_flag,
		boolean verbose_flag )
{
  char *test_case;
  char *result_string;
  int retval;
  boolean result;

  retval = iswupper (wc_ansp->param[0][0]);

  set_testcase (ansp, 1, &test_case);
  set_retvalstr (retval, &result_string);

  result = check_result (result_string, ansp->result);
  display_result (ansp, test_case, result_string, ansp->result,
		  result, genans_flag, verbose_flag);

  mem_free ((void *) result_string);
  mem_free ((void *) test_case);

  return (result);
}

/******************************************
 * TEST: int  iswlower ( wint_t wc )      *
 ******************************************/
boolean
iswlower_test ( answer * ansp,
		wc_answer * wc_ansp,
		boolean genans_flag,
		boolean verbose_flag )
{
  char *test_case;
  char *result_string;
  int retval;
  boolean result;

  retval = iswlower (wc_ansp->param[0][0]);

  set_testcase (ansp, 1, &test_case);
  set_retvalstr (retval, &result_string);

  result = check_result (result_string, ansp->result);
  display_result (ansp, test_case, result_string, ansp->result,
		  result, genans_flag, verbose_flag);

  mem_free ((void *) result_string);
  mem_free ((void *) test_case);

  return (result);
}

/******************************************
 * TEST: int  iswalnum ( wint_t wc )      *
 ******************************************/
boolean
iswalnum_test ( answer * ansp,
		wc_answer * wc_ansp,
		boolean genans_flag,
		boolean verbose_flag )
{
  char *test_case;
  char *result_string;
  int retval;
  boolean result;

  retval = iswalnum (wc_ansp->param[0][0]);

  set_testcase (ansp, 1, &test_case);
  set_retvalstr (retval, &result_string);

  result = check_result (result_string, ansp->result);
  display_result (ansp, test_case, result_string, ansp->result,
		  result, genans_flag, verbose_flag);

  mem_free ((void *) result_string);
  mem_free ((void *) test_case);

  return (result);
}

/******************************************
 * TEST: int  iswalpha ( wint_t wc )      *
 ******************************************/
boolean
iswalpha_test ( answer * ansp,
		wc_answer * wc_ansp,
		boolean genans_flag,
		boolean verbose_flag )
{
  char *test_case;
  char *result_string;
  int retval;
  boolean result;

  retval = iswalpha (wc_ansp->param[0][0]);

  set_testcase (ansp, 1, &test_case);
  set_retvalstr (retval, &result_string);

  result = check_result (result_string, ansp->result);
  display_result (ansp, test_case, result_string, ansp->result,
		  result, genans_flag, verbose_flag);

  mem_free ((void *) result_string);
  mem_free ((void *) test_case);

  return (result);
}

/******************************************
 * Test: int  iswdigit ( wint_t wc )      *
 ******************************************/
boolean
iswdigit_test ( answer * ansp,
		wc_answer * wc_ansp,
		boolean genans_flag,
		boolean verbose_flag )
{
  char *test_case;
  char *result_string;
  int retval;
  boolean result;

  retval = iswdigit (wc_ansp->param[0][0]);

  set_testcase (ansp, 1, &test_case);
  set_retvalstr (retval, &result_string);

  result = check_result (result_string, ansp->result);
  display_result (ansp, test_case, result_string, ansp->result,
		  result, genans_flag, verbose_flag);

  mem_free ((void *) result_string);
  mem_free ((void *) test_case);

  return (result);
}

/*******************************************
 * TEST: int  iswxdigit ( wint_t wc )      *
 *******************************************/
boolean
iswxdigit_test ( answer * ansp,
		 wc_answer * wc_ansp,
		 boolean genans_flag,
		 boolean verbose_flag )
{
  char *test_case;
  char *result_string;
  int retval;
  boolean result;

  retval = iswxdigit (wc_ansp->param[0][0]);

  set_testcase (ansp, 1, &test_case);
  set_retvalstr (retval, &result_string);

  result = check_result (result_string, ansp->result);
  display_result (ansp, test_case, result_string, ansp->result,
		  result, genans_flag, verbose_flag);

  mem_free ((void *) result_string);
  mem_free ((void *) test_case);

  return (result);
}

#ifdef HAVE_ISWBLANK
/******************************************
 * TEST: int  iswblank ( wint_t wc )      *
 ******************************************/
boolean
iswblank_test ( answer * ansp,
		wc_answer * wc_ansp,
		boolean genans_flag,
		boolean verbose_flag )
{
  char *test_case;
  char *result_string;
  int retval;
  boolean result;

  retval = iswblank (wc_ansp->param[0][0]);

  set_testcase (ansp, 1, &test_case);
  set_retvalstr (retval, &result_string);

  result = check_result (result_string, ansp->result);
  display_result (ansp, test_case, result_string, ansp->result,
		  result, genans_flag, verbose_flag);

  mem_free ((void *) result_string);
  mem_free ((void *) test_case);

  return (result);
}
#endif

/******************************************
 * TEST: int  iswspace ( wint_t wc )      *
 ******************************************/
boolean
iswspace_test ( answer * ansp,
		wc_answer * wc_ansp,
		boolean genans_flag,
		boolean verbose_flag )
{
  char *test_case;
  char *result_string;
  int retval;
  boolean result;

  retval = iswspace (wc_ansp->param[0][0]);

  set_testcase (ansp, 1, &test_case);
  set_retvalstr (retval, &result_string);

  result = check_result (result_string, ansp->result);
  display_result (ansp, test_case, result_string, ansp->result,
		  result, genans_flag, verbose_flag);

  mem_free ((void *) result_string);
  mem_free ((void *) test_case);

  return (result);
}

/******************************************
 * TEST: int  iswcntrl ( wint_t wc )      *
 ******************************************/
boolean
iswcntrl_test ( answer * ansp,
		wc_answer * wc_ansp,
		boolean genans_flag,
		boolean verbose_flag )
{
  char *test_case;
  char *result_string;
  int retval;
  boolean result;

  retval = iswcntrl (wc_ansp->param[0][0]);

  set_testcase (ansp, 1, &test_case);
  set_retvalstr (retval, &result_string);

  result = check_result (result_string, ansp->result);
  display_result (ansp, test_case, result_string, ansp->result,
		  result, genans_flag, verbose_flag);

  mem_free ((void *) result_string);
  mem_free ((void *) test_case);

  return (result);
}

/******************************************
 * TEST: int  iswpunct ( wint_t wc )      *
 ******************************************/
boolean
iswpunct_test ( answer * ansp,
		wc_answer * wc_ansp,
		boolean genans_flag,
		boolean verbose_flag )
{
  char *test_case;
  char *result_string;
  int retval;
  boolean result;

  retval = iswpunct (wc_ansp->param[0][0]);

  set_testcase (ansp, 1, &test_case);
  set_retvalstr (retval, &result_string);

  result = check_result (result_string, ansp->result);
  display_result (ansp, test_case, result_string, ansp->result,
		  result, genans_flag, verbose_flag);

  mem_free ((void *) result_string);
  mem_free ((void *) test_case);

  return (result);
}

/******************************************
 * TEST: int  iswgraph ( wint_t wc )      *
 ******************************************/
boolean
iswgraph_test ( answer * ansp,
		wc_answer * wc_ansp,
		boolean genans_flag,
		boolean verbose_flag )
{
  char *test_case;
  char *result_string;
  int retval;
  boolean result;

  retval = iswgraph (wc_ansp->param[0][0]);

  set_testcase (ansp, 1, &test_case);
  set_retvalstr (retval, &result_string);

  result = check_result (result_string, ansp->result);
  display_result (ansp, test_case, result_string, ansp->result,
		  result, genans_flag, verbose_flag);

  mem_free ((void *) result_string);
  mem_free ((void *) test_case);

  return (result);
}

/******************************************
 * TEST: int  iswprint ( wint_t wc )      *
 ******************************************/
boolean
iswprint_test ( answer * ansp,
		wc_answer * wc_ansp,
		boolean genans_flag,
		boolean verbose_flag )
{
  char *test_case;
  char *result_string;
  int retval;
  boolean result;

  retval = iswprint (wc_ansp->param[0][0]);

  set_testcase (ansp, 1, &test_case);
  set_retvalstr (retval, &result_string);

  result = check_result (result_string, ansp->result);
  display_result (ansp, test_case, result_string, ansp->result,
		  result, genans_flag, verbose_flag);

  mem_free ((void *) result_string);
  mem_free ((void *) test_case);

  return (result);
}

/*********************************************************
 * TEST: int  iswctype ( wint_t wc, wctype_t desc )      *
 *********************************************************/
boolean
iswctype_test ( answer * ansp,
		wc_answer * wc_ansp,
		boolean genans_flag,
		boolean verbose_flag )
{
  char *test_case;
  char *result_string;
  wctype_t desc;
  int retval;
  boolean result;

  desc = wctype (ansp->param[1]);
  if (desc)
    {
      retval = iswctype (wc_ansp->param[0][0], desc);

      set_testcase (ansp, 2, &test_case);
      set_retvalstr (retval, &result_string);

      result = check_result (result_string, ansp->result);
      display_result (ansp, test_case, result_string, ansp->result,
		      result, genans_flag, verbose_flag);
      mem_free ((void *) result_string);
      mem_free ((void *) test_case);
    }
  else
    {
      fprintf (stderr, "[ERROR] wctype: [%s] is not defined in system.\n",
	       ansp->param[1]);
      result = false;
    }

  return (result);
}

/**************************************
 * TEST: wint_t towupper (wint_t wc)  *
 **************************************/
boolean
towupper_test ( answer * ansp,
		wc_answer * wc_ansp,
		boolean genans_flag,
		boolean verbose_flag )
{
  char *test_case;
  char *result_string;
  int retval;
  boolean result;

  retval = towupper (wc_ansp->param[0][0]);

  set_testcase (ansp, 1, &test_case);
  set_retvalstr_lc (retval, &result_string);

  result = check_result (result_string, ansp->result);
  display_result (ansp, test_case, result_string, ansp->result,
		  result, genans_flag, verbose_flag);

  mem_free ((void *) result_string);
  mem_free ((void *) test_case);

  return (result);
}

/**************************************
 * TEST: wint_t towlower (wint_t wc)  *
 **************************************/
boolean
towlower_test ( answer * ansp,
		wc_answer * wc_ansp,
		boolean genans_flag,
		boolean verbose_flag )
{
  char *test_case;
  char *result_string;
  int retval;
  boolean result;

  retval = towlower (wc_ansp->param[0][0]);

  set_testcase (ansp, 1, &test_case);
  set_retvalstr_lc (retval, &result_string);

  result = check_result (result_string, ansp->result);
  display_result (ansp, test_case, result_string, ansp->result,
		  result, genans_flag, verbose_flag);

  mem_free ((void *) result_string);
  mem_free ((void *) test_case);

  return (result);
}

/*******************************************************
 * TEST: wint_t towctrans (wint_t wc, wctrans_t desc)  *
 *******************************************************/
boolean
towctrans_test ( answer * ansp,
		 wc_answer * wc_ansp,
		 boolean genans_flag,
		 boolean verbose_flag )
{
  char *test_case;
  char *result_string;
  wctrans_t desc;
  int retval;
  boolean result;

  desc = wctrans (ansp->param[1]);
  if (desc)
    {
      retval = towctrans (wc_ansp->param[0][0], desc);

      set_testcase (ansp, 2, &test_case);
      set_retvalstr_lc (retval, &result_string);

      result = check_result (result_string, ansp->result);
      display_result (ansp, test_case, result_string, ansp->result,
		      result, genans_flag, verbose_flag);
      mem_free ((void *) result_string);
      mem_free ((void *) test_case);
    }
  else
    {
      fprintf (stderr,
	       "[ERROR] wctrans: [%s] is not defined in system.\n",
	       ansp->param[1]);
      result = false;
    }

  return (result);
}
