/*
 *
 * This software is subject to the terms of the IBM Public License.
 * You must accept the terms of this license to use this software.
 *
 *  Copyright (C) 2000, International Business Machines Corporation
 * and others.  All Rights Reserved.
 *
 *  Version : 1.0 (2000-07-19)
 *
 *  Author  :   Tadayuki Yoshida <tadayuki@jp.ibm.com>
 *
 */

#include "glibctest.h"
#include "test_lang.h"
#include <time.h>

supported_API apilist[] = {
  {"nl_langinfo <KEYWORD> - - <value>",
   "get language information."}
  ,
  {"localeconv <keyword> - - <value>",
   "get numeric formatting information."}
  ,
  {"strftime <format> - - <value>",
   "format date and time."}
  ,
  {"wcsftime <format> - - <value>",
   "format date and time (wide-characters)."}
  ,
  {"strptime <format> - - <structure>",
   "convert a string representation of time to a time to structure."}
  ,
  {"strfmon <format> <value> - <representation>",
   "format money."}
  ,
  {"\0", "\0"}
};

/*
 * main( )
 *
 */

int
main (int argc, char *argv[])
{
  answer *ansp;
  wc_answer *wc_ansp;
  api_table *tp;
  params prm;
  char progname[] = PROGRAM_NAME;
  int case_cnt = 0;
  int error_cnt = 0;
  boolean result;

  int status;
  boolean genans_local = false;

  system_info ();

  /*
   * Option search
   */

  getparams (argc, argv, &prm, progname);

  /*
   * API test function register
   */

  tp = api_table_init (15);
  api_table_create (tp);

  /*
   * Mail Loop
   */
  while (true)
    {
      ansp = (answer *) mem_alloc (sizeof (answer));
      wc_ansp = (wc_answer *) mem_alloc (sizeof (wc_answer));

      print_prompt (&prm);
      status = input_reader (prm.input_fp, ansp, wc_ansp, &genans_local);

      if (status == (int) NULL)
	{
          mem_free ((void *)ansp);
          mem_free ((void *)wc_ansp);
	  fclose (prm.input_fp);
	  break;
	}
      if (status == EMPTYLINE || status == INSUFFICIENTLINE)
	{
          mem_free ((void *)ansp);
          mem_free ((void *)wc_ansp);
	  continue;
	}
      fprintf (stderr, "start check.\n");
      result = api_table_select (tp, ansp, wc_ansp,
				 (genans_local || prm.genans_global),
				 prm.verbose_flag);
      error_cnt += (result == false) ? 1 : 0;
      case_cnt++;

      genans_local = false;
      free_ans (ansp, wc_ansp);
    }

  api_table_free (tp);

  result_report (case_cnt, error_cnt, "");

  return (0);
}
