/*
 *
 * This software is subject to the terms of the IBM Public License.
 * You must accept the terms of this license to use this software.
 *
 *  Copyright (C) 2000, International Business Machines Corporation
 * and others.  All Rights Reserved.
 *
 *  Version : 1.0 (2000-07-19)
 *
 *  Author  :   Tadayuki Yoshida <tadayuki@jp.ibm.com>
 *
 */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <wchar.h>
#include <limits.h>
#include "glibctest.h"

/*
 *
 *  int convert_mbswcs  ( wchart *wc, char *mbs )
 *
 *  Prior to passing params to wcsxxx APIs, the params are converted
 *  to wchar_t string.
 *
 */

void
convert_mbswcs (wchar_t ** ws, char * mbs)
{
  size_t mbslen, wslen, wsbuflen;
  wchar_t *wsbuf;

  mbslen = stringlen (mbs) + 1;
  wsbuflen = mbslen / 2 + 1;
  wsbuf = (wchar_t *) mem_calloc (wsbuflen, sizeof (wchar_t));
  wslen = mbstowcs (wsbuf, mbs, wsbuflen);

  if (wslen < 0)
    {
      printf ("mbstowcs failed in %s \n", mbs);
      *ws = L"NULL";
    }

  while (wslen == wsbuflen)
    {
      mem_free ((void *) wsbuf);
      wsbuflen *= 2;
      wsbuf = (wchar_t *) mem_calloc (wsbuflen, sizeof (wchar_t));
      wslen = mbstowcs (wsbuf, mbs, wsbuflen);
    }

  *ws = wsbuf;
}

void
convert_wcsmbs ( char ** mbs, wchar_t * wcs)
{
  size_t tmpsize;
  wchar_t *wsbuf;

  tmpsize = wstringlen (wcs) * MB_LEN_MAX + 1;
  *mbs = (char *) mem_calloc (tmpsize, sizeof (char));

  wcstombs (*mbs, wcs, tmpsize);
}
