/*
 *
 * This software is subject to the terms of the IBM Public License.
 * You must accept the terms of this license to use this software.
 *
 *  Copyright (C) 2000, International Business Machines Corporation
 * and others.  All Rights Reserved.
 *
 *  Version : 1.0 (2000-07-19)
 *
 *  Author  :   Tadayuki Yoshida <tadayuki@jp.ibm.com>
 *
 */

#include "glibctest.h"
#include <stdio.h>
#include <locale.h>

void
display_verbose (char *test_string,
		 char *system, char *expected, boolean result_flag)
{
  char *tmpcase, *tmpsys, *tmpexp;

  replace_char_to_tag (&tmpcase, test_string);
  replace_char_to_tag (&tmpsys, system);
  replace_char_to_tag (&tmpexp, expected);

  if (result_flag)
    {
      printf (" %s sys[%s] =  exp[%s]", tmpcase, tmpsys, tmpexp);
    }
  else
    {
      printf (" %s sys[%s] != exp[%s]", tmpcase, tmpsys, tmpexp);
    }
  mem_free ((void *)tmpcase);
  mem_free ((void *)tmpsys);
  mem_free ((void *)tmpexp);
}

void
display_result (answer * ansp,
		char *test_string,
		char *result_string,
		char *expected_result,
		boolean result, boolean genans_flag, boolean verbose_flag)
{
  int i;
  answer tmp;
  char *tmpcase, *tmpsys, *tmpexp;
  FILE *out_fp;
  char outfilename[32];

  if (genans_flag)
    {
      out_fp = stdout;
      replace_char_to_tag (&(tmp.api_name), ansp->api_name);
      for (i = 0; i < PARAM_NUM; i++)
	{
	  replace_char_to_tag (&(tmp.param[i]), ansp->param[i]);
	}
      replace_char_to_tag (&(tmp.result), result_string);

      fprintf (out_fp, "%s %s %s %s %s",
	       tmp.api_name, tmp.param[0], tmp.param[1], tmp.param[2], tmp.result);
      fprintf (out_fp, "\n");
      mem_free ((void *)tmp.api_name);
      for (i = 0; i < PARAM_NUM; i++)
	{
	  mem_free ((void *)tmp.param[i]);
	}
      mem_free ((void *)tmp.result);
    }
  else
    {
      sprintf (outfilename, "log.%s", getenv ("LANG"));
      out_fp = fopen (outfilename, "a");
      if (stringeq (expected_result, "NULL")
	  && stringeq (result_string, "(null)"))
	{
	  fprintf (out_fp, SUCCSTR);
	  if (verbose_flag)
	    {
	      fprintf (stderr, SUCCSTR);
	    }
	  result = true;
	}
      else
	{
	  if (result)
	    {
	      fprintf (out_fp, SUCCSTR);
	      if (verbose_flag)
		{
		  fprintf (stderr, SUCCSTR);
		}
	    }
	  else
	    {
	      fprintf (out_fp, FAILSTR);
	      if (verbose_flag)
		{
		  fprintf (stderr, FAILSTR);
		}
	    }
	}

      replace_char_to_tag (&tmpcase, test_string);
      replace_char_to_tag (&tmpsys, result_string);
      replace_char_to_tag (&tmpexp, expected_result);

      if (result)
	{
	  fprintf (out_fp, " %s sys[%s] =  exp[%s]", tmpcase, tmpsys, tmpexp);
	  if (verbose_flag)
	    {
	      fprintf (stderr, " %s sys[%s] =  exp[%s]", tmpcase, tmpsys, tmpexp);
	    }
	}
      else
	{
	  fprintf (out_fp, " %s sys[%s] != exp[%s]", tmpcase, tmpsys, tmpexp);
	  if (verbose_flag)
	    {
	      fprintf (stderr, " %s sys[%s] != exp[%s]", tmpcase, tmpsys, tmpexp);
	    }
	}
      mem_free ((void *)tmpcase);
      mem_free ((void *)tmpsys);
      mem_free ((void *)tmpexp);

      fprintf (out_fp, "\n");
      if (verbose_flag)
	{
	  fprintf (stderr, "\n");
	}
      fclose (out_fp);
    }
}
