/*
 *
 * This software is subject to the terms of the IBM Public License.
 * You must accept the terms of this license to use this software.
 *
 *  Copyright (C) 2000, International Business Machines Corporation
 * and others.  All Rights Reserved.
 *
 *  Version : 1.0 (2000-07-19)
 *
 *  Author  :   Tadayuki Yoshida <tadayuki@jp.ibm.com>
 *
 */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "glibctest.h"

char *
fgetstr ( char * s, int size, FILE * fp )
{
  int cnt = 0;
  size_t ret;
  unsigned char c;

  clearerr (fp);

  while (cnt < (size - 1))
    {
      ret = fread ((void *)&c, 1, 1, fp);
      s[cnt] = c;
      if (c == '\n')
	{
	  s[cnt+1] = '\0';
	  return s;
	}
      if (feof (fp))
	{
	  s[cnt] = '\0';
	  return s;
	}
      if (ferror (fp))
	{
	  s[cnt] = '\0';
	  return s;
	}
      cnt++;
    }

  s[size-1] = '\0';
  return s;
}
