/*
 *
 * This software is subject to the terms of the IBM Public License.
 * You must accept the terms of this license to use this software.
 *
 *  Copyright (C) 2000, International Business Machines Corporation
 * and others.  All Rights Reserved.
 *
 *  Version : 1.0 (2000-07-19)
 *
 *  Author  :   Tadayuki Yoshida <tadayuki@jp.ibm.com>
 *
 */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "glibctest.h"

/*
 * int convert_params ( void )
 *
 * Converts parameter to unsinged long array, if the string is 
 *  proceeded by 0x or 0x.
 *
 */

static void
convert_params (answer * ansp)
{
  int i, j, len;
  char *str;
  unsigned char *rstr;
  char tmp[3];
  size_t tmpsize;

  for (i = 0; i < PARAM_NUM; i++)
    {
      if (ansp->param[i][0] == '0'
	  && (ansp->param[i][1] == 'x' || ansp->param[i][1] == 'X'))
	{
	  stringpcpy (&str, (ansp->param[i]) + 2);	/* remove 0x */
	  tmpsize = stringlen (str);
	  rstr = (unsigned char *) mem_alloc (sizeof (char) * tmpsize + 1);
	  xstr2ul (str, rstr);
	  mem_free ((void *)ansp->param[i]);
	  ansp->param[i] = (char *) mem_calloc (stringlen (rstr) + 1, sizeof (char));
	  stringcpy (ansp->param[i], (char *) rstr);
 	  mem_free ((void *) str);
	  mem_free ((void *) rstr);
	}
    }

  if (ansp->result[0] == '0'
      && (ansp->result[1] == 'x' || ansp->result[1] == 'X'))
    {
      stringpcpy (&str, ansp->result + 2);	/* remove 0x */
      tmpsize = stringlen (str);
      rstr = (unsigned char *) mem_alloc (sizeof (char) * tmpsize + 1);
      xstr2ul (str, rstr);
      mem_free ((void *)ansp->result);
      ansp->result = (char *) mem_calloc (stringlen (rstr) + 1, sizeof (char));
      stringcpy (ansp->result, (char *) rstr);
      mem_free ((void *) str);
      mem_free ((void *) rstr);
    }
}

/*
 * int input_reader( answer *ansp, wc_answer *wc_ansp, int genans_flagp )
 *
 */

int
input_reader (FILE * fp, answer * ansp, wc_answer * wc_ansp,
	      boolean * genans_flagp)
{
  int i;
  int param_counter = 0;
  char *bufp, *bufpsave;

  if ( NULL != get_oneline (fp, &bufp) )
    {
      if (iscommentline (bufp, '#'))
	{
	  mem_free ((void *)bufp);
	  return (EMPTYLINE);
	}

      param_counter = count_param (bufp);

      /* empty line */
      if (param_counter < 1)
	{
	  mem_free ((void *)bufp);
	  return (EMPTYLINE);
	}

      bufpsave = bufp;
      bufp = set_token_from_buf (bufp, &(ansp->api_name));

      /* format help line */
      if (param_counter == 1)
	{
	  mem_free ((void *)bufp);
	  return (print_format_help (ansp->api_name));
	}

      /* insufficient line */
      if (param_counter < (PARAM_NUM + 1))
	{
	  fprintf (stderr, OOPSSTR);
	  fprintf (stderr,
		   " Insufficient number of parameters (needs three params). \n");
	  mem_free ((void *)bufp);
	  return (INSUFFICIENTLINE);
	}

      /* expected result is not specified */
      if (param_counter == (PARAM_NUM + 1))
	{
	  *genans_flagp = true;
	}

      for (i = 0; i < PARAM_NUM; i++)
	{
	  bufp = set_token_from_buf (bufp, &(ansp->param[i]));
	}

      bufp = set_token_from_buf (bufp, &(ansp->result));

      convert_params (ansp);

      convert_mbswcs (&(wc_ansp->api_name), ansp->api_name);

      for (i = 0; i < PARAM_NUM; i++)
	{
	  convert_mbswcs (&(wc_ansp->param[i]), ansp->param[i]);
	}

      convert_mbswcs (&(wc_ansp->result), ansp->result);

      mem_free ((void *)bufpsave);
      return (READSUCCESS);
    }
  else
    {
      mem_free ((void *)bufp);
      return ( (int) NULL );
    }
}
