/*
 *
 * This software is subject to the terms of the IBM Public License.
 * You must accept the terms of this license to use this software.
 *
 *  Copyright (C) 2000, International Business Machines Corporation
 * and others.  All Rights Reserved.
 *
 *  Version : 1.0 (2000-07-19)
 *
 *  Author  :   Tadayuki Yoshida <tadayuki@jp.ibm.com>
 *
 */
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include "glibctest.h"

void
replace_tag_to_char ( char * src, char ** target )
{
  int i;
  char *buf;
  char *srcp = src;
  int incr;

  buf = (char *) mem_calloc (stringlen (src) + 1, sizeof (char));

  /* search tag */
  i = 0;
  while (*srcp != (char) NULL)
    {
      incr = 1;
      if (*srcp == '<')
	{
	  if (stringeqn ((srcp + 1), "SPC>", 4))
	    {
	      buf[i] = ' ';
	      incr = 5;
	    }
	  else if (stringeqn ((srcp + 1), "TAB>", 4))
	    {
	      buf[i] = '\t';
	      incr = 5;
	    }
	  else if (stringeqn ((srcp + 1), "NUL>", 4))
	    {
	      buf[i] = (char) NULL;
	      incr = 5;
	    }
	  else if (stringeqn ((srcp + 1), "LF>", 3))
	    {
	      buf[i] = '\n';
	      incr = 4;
	    }
	  else if (stringeqn ((srcp + 1), "CR>", 3))
	    {
	      buf[i] = '\r';
	      incr = 4;
	    }
	  else if (stringeqn ((srcp + 1), "VT>", 3))
	    {
	      buf[i] = '\v';
	      incr = 4;
	    }
	  else if (stringeqn ((srcp + 1), "BT>", 3))
	    {
	      buf[i] = '\b';
	      incr = 4;
	    }
	  else if (stringeqn ((srcp + 1), "FF>", 3))
	    {
	      buf[i] = '\f';
	      incr = 4;
	    }
	  else
	    {
	      buf[i] = *srcp;
	    }
	}
      else
	{
	  buf[i] = *srcp;
	}
      srcp += incr;
      i++;
    }
  buf[i] = (char) NULL;

  stringpcpy (target, buf);

  mem_free ((void *)buf);
}

void
replace_char_to_tag ( char ** target, char * src )
{
  char *tmpbufp, *tmpbufpnew;
  char tmp[2];
  int i;
  size_t maxlen;
  size_t incr_unit = 32;
  size_t tmplen;

  /* search tag */
  i = 0;

  maxlen = 64;
  tmpbufp = (char *) mem_calloc (maxlen, sizeof (char));

  while (*(src + i) != (char) NULL)
    {
      tmplen = stringlen (tmpbufp);
      if ( tmplen + 5 > maxlen )
	{
	  maxlen += incr_unit;
	  tmpbufpnew = (char *) mem_calloc (maxlen, sizeof (char));
	  memcpy (tmpbufpnew, tmpbufp, maxlen - incr_unit);
	  mem_free ((void *)tmpbufp);
	  tmpbufp = tmpbufpnew;
	}

      switch (*(src + i))
	{
	case ' ':
	  {
	    stringcat (tmpbufp, "<SPC>");
	    break;
	  }
	case '\t':
	  {
	    stringcat (tmpbufp, "<TAB>");
	    break;
	  }
	case '\n':
	  {
	    stringcat (tmpbufp, "<LF>");
	    break;
	  }
	case '\r':
	  {
	    stringcat (tmpbufp, "<CR>");
	    break;
	  }
	case '\v':
	  {
	    stringcat (tmpbufp, "<VT>");
	    break;
	  }
	case '\b':
	  {
	    stringcat (tmpbufp, "<BT>");
	    break;
	  }
	case '\f':
	  {
	    stringcat (tmpbufp, "<FF>");
	    break;
	  }
	default:
	  {
	    sprintf (tmp, "%c", *(src + i));
	    stringcat (tmpbufp, tmp);
	    break;
	  }
	}
      i++;
    }

  if (i == 0)
    {
      stringpcpy (target, "<NUL>");
    }
  else
    {
      stringpcpy (target, tmpbufp);
    }

  mem_free ((void *)tmpbufp);
}
