/*
 *
 * This software is subject to the terms of the IBM Public License.
 * You must accept the terms of this license to use this software.
 *
 *  Copyright (C) 2000, International Business Machines Corporation
 * and others.  All Rights Reserved.
 *
 *  Version : 1.0 (2000-07-19)
 *
 *  Author  :   Tadayuki Yoshida <tadayuki@jp.ibm.com>
 *
 */

#include <stdio.h>
#include <locale.h>

void
result_report (int case_cnt, int error_cnt, char *message)
{
  FILE *out_fp;
  char outfilename[32];

  sprintf (outfilename, "log.%s", getenv ("LANG"));
  out_fp = fopen (outfilename, "a");

  fprintf (stderr, "\n========== RESULT REPORT ================\n");
  fprintf (out_fp, "\n========== RESULT REPORT ================\n");
  fprintf (stderr, " test case : %d  success : %d fail : %d\n", case_cnt,
	   case_cnt - error_cnt, error_cnt);
  fprintf (out_fp, " test case : %d  success : %d fail : %d\n", case_cnt,
	   case_cnt - error_cnt, error_cnt);
  if (error_cnt == 0)
    {
      fprintf (stderr, " API test successfully ended.\n");
      fprintf (out_fp, " API test successfully ended.\n");
    }
  else
    {
      fprintf (stderr, " %d errors checked.\n", error_cnt);
      fprintf (out_fp, " %d errors checked.\n", error_cnt);
    }

  fprintf (stderr, " Log file : %s\n", outfilename);
  fprintf (out_fp, " Log file : %s\n", outfilename);

  fprintf (stderr, "=========================================\n");
  fprintf (out_fp, "=========================================\n");

  fclose (out_fp);
}
