/*
 *
 * This software is subject to the terms of the IBM Public License.
 * You must accept the terms of this license to use this software.
 *
 *  Copyright (C) 2000, International Business Machines Corporation
 * and others.  All Rights Reserved.
 *
 *  Version : 1.0 (2000-07-19)
 *
 *  Author  :   Tadayuki Yoshida <tadayuki@jp.ibm.com>
 *
 */
#include "glibctest.h"
#include <stdio.h>

char *
set_token_from_buf ( char *buf, char **tokenp )
{
  size_t len;
  char *src;
  int i = 0, j, idx = 0, start, end;

  while (iswhitespace(buf[idx]))
    {
      idx++;	/* skip white space */
    }

  start = idx;
  while (!iswhitespace(buf[idx]) && buf[idx] != (char) NULL)
    {
      idx++;
    }
  end = idx;
  src = (char *) mem_calloc (end - start + 1, sizeof (char));

  for (i=start, j=0 ; i < end ; i++, j++)
    {
      src[j] = buf[i];
    }
  src[j] = (char) NULL;

  replace_tag_to_char (src, tokenp);

  mem_free ((void *) src);

  return (buf+idx);
}
