/*
 *
 * This software is subject to the terms of the IBM Public License.
 * You must accept the terms of this license to use this software.
 *
 *  Copyright (C) 2000, International Business Machines Corporation
 * and others.  All Rights Reserved.
 *
 *  Version : 1.0 (2000-07-19)
 *
 *  Author  :   Tadayuki Yoshida <tadayuki@jp.ibm.com>
 *
 */
#include <stdio.h>
#include <stdlib.h>
#include <sys/utsname.h>
#include <locale.h>
#ifdef HAVE_FEATURES_H
#include <features.h>
#endif

#include <time.h>

#include "glibctest.h"

/***********************************************************
*                                                          *
* int system_info ( int argc,                              *
*                 char **argv,                             *
*                 params *paramp )                         *
*                                                          *
************************************************************/

int
system_info (void)
{
  FILE *out_fp;
  char outfilename[32];
  char locale[32];
  char *timestr;
  time_t tmbin;

  struct utsname sysuname;
#if defined __GLIBC__ && defined __GLIBC_MINOR__
  int major = __GLIBC__, minor = __GLIBC_MINOR__;
#endif

  setlocale (LC_ALL, "");
  stringcpy (locale, getenv ("LANG"));

  time (&tmbin);
  timestr = ctime (&tmbin);

  sprintf (outfilename, "log.%s", locale);
  out_fp = fopen (outfilename, "w");

  (void) uname (&sysuname);

  fprintf (stderr, "\n========= SYSTEM INFORMATION ==========\n");
  fprintf (out_fp, "\n========= SYSTEM INFORMATION ==========\n");

  fprintf (stderr, " System   : %s\n", sysuname.sysname);
  fprintf (out_fp, " System   : %s\n", sysuname.sysname);

  fprintf (stderr, " Nodename : %s\n", sysuname.nodename);
  fprintf (out_fp, " Nodename : %s\n", sysuname.nodename);

  fprintf (stderr, " Release  : %s\n", sysuname.release);
  fprintf (out_fp, " Release  : %s\n", sysuname.release);

  fprintf (stderr, " Version  : %s\n", sysuname.version);
  fprintf (out_fp, " Version  : %s\n", sysuname.version);

  fprintf (stderr, " Machine  : %s\n", sysuname.machine);
  fprintf (out_fp, " Machine  : %s\n", sysuname.machine);

  fprintf (stderr, " Locale   : %s\n", locale);
  fprintf (out_fp, " Locale   : %s\n", locale);

#if defined __GLIBC__ && defined __GLIBC_MINOR__
  fprintf (stderr, " GlibC    : %d.%d\n", major, minor);
  fprintf (out_fp, " GlibC    : %d.%d\n", major, minor);
#endif

  fprintf (stderr, " Exec Date: %s", timestr);
  fprintf (out_fp, " Exec Date: %s", timestr);

  fprintf (stderr, "=======================================\n\n");
  fprintf (out_fp, "=======================================\n\n");

  fclose (out_fp);

  return (0);
}
