/*
 *
 * This software is subject to the terms of the IBM Public License.
 * You must accept the terms of this license to use this software.
 *
 *  Copyright (C) 2000, International Business Machines Corporation
 * and others.  All Rights Reserved.
 *
 *  Version : 1.0 (2000-07-19)
 *
 *  Author  :   Tadayuki Yoshida <tadayuki@jp.ibm.com>
 *
 */
#include "glibctest.h"
#include "test_mbstowcs.h"

static boolean mbstowcs_test ( answer *, wc_answer *, boolean, boolean );
static boolean wcstombs_test ( answer *, wc_answer *, boolean, boolean );
static boolean mblen_test ( answer *, wc_answer *, boolean, boolean );
static boolean wcslen_test ( answer *, wc_answer *, boolean, boolean );

void
api_table_create ( const api_table *tp )
{
  api_table_add (tp, "mbstowcs", mbstowcs_test);
  api_table_add (tp, "wcstombs", wcstombs_test);
  api_table_add (tp, "mblen", mblen_test);
  api_table_add (tp, "wcslen", wcslen_test);
}

/*
 * TEST: size_t   mbstowcs( wchar_t *ws, const char *s, size_t n)
 */
static boolean
mbstowcs_test ( answer * ansp,
		wc_answer * wc_ansp,
		boolean genans_flag,
		boolean verbose_flag )
{
  int i;
  char *test_case;
  char *result_string;
  wchar_t *result_wstring;
  boolean result;
  size_t retval;
  size_t tmpsize;
  size_t padding = 20;

  tmpsize = stringlen (ansp->api_name) + stringlen (ansp->param[0]) + stringlen (ansp->param[1]) + stringlen (ansp->param[2]) + padding;
  test_case = (char *) mem_calloc (tmpsize, sizeof (char));

  sprintf (test_case, "%s(result_wstring,%s,%s)", ansp->api_name,
	   ansp->param[0], ansp->param[1]);
  tmpsize = (size_t) atoi (ansp->param[1]);
  result_wstring = (wchar_t *) mem_calloc (tmpsize, sizeof (wchar_t));

  retval = mbstowcs (result_wstring, ansp->param[0], tmpsize);
  if (retval == -1)
    {
      printf ("FAILURE: %s failed.\n", test_case);
      result = false;
    }
  else
    {
      convert_wcsmbs (&result_string, result_wstring);

      result = wstringeqn (result_wstring, wc_ansp->result, tmpsize);
      display_result (ansp, test_case, result_string, ansp->result,
		      result, genans_flag, verbose_flag);
      mem_free ((void *) result_string);
    }

  mem_free ((void *) result_wstring);
  mem_free ((void *) test_case);

  return (result);
}

/*
 * TEST: size_t   wcstombs( char *s, const wchar_t *ws, size_t n)
 */
static boolean
wcstombs_test ( answer * ansp,
		wc_answer * wc_ansp,
		boolean genans_flag,
		boolean verbose_flag )
{
  int i;
  char *test_case;
  char *result_string;
  wchar_t *result_wstring;
  boolean result;
  size_t retval;
  size_t tmpsize;
  size_t padding = 20;

  tmpsize = stringlen (ansp->api_name) + stringlen (ansp->param[0]) + stringlen (ansp->param[1]) + stringlen (ansp->param[2]) + padding;
  test_case = (char *) mem_calloc (tmpsize, sizeof (char));

  sprintf (test_case, "%s(result_string,%s,%s)", ansp->api_name,
	   ansp->param[0], ansp->param[1]);
  tmpsize = (size_t) atoi (ansp->param[1]);
  result_string = (char *) mem_calloc (tmpsize, sizeof (char));

  retval = wcstombs (result_string, wc_ansp->param[0], tmpsize);
  if (retval == -1)
    {
      printf ("FAILURE: %s failed.\n", test_case);
      result = false;
    }
  else
    {
      result = stringeqn (result_string, ansp->result, tmpsize);
      display_result (ansp, test_case, result_string, ansp->result,
		      result, genans_flag, verbose_flag);
    }

  mem_free ((void *) result_string);
  mem_free ((void *) test_case);

  return (result);
}

/*
 * TEST: int   mblen( const char *s, size_t n )
 */
static boolean
mblen_test ( answer * ansp,
	     wc_answer * wc_ansp,
	     boolean genans_flag,
	     boolean verbose_flag )
{
  int i;
  char *test_case;
  char *result_string;
  boolean result;
  size_t retval;
  size_t tmpsize;
  size_t padding = 20;

  tmpsize = stringlen (ansp->api_name) + stringlen (ansp->param[0]) + stringlen (ansp->param[1]) + stringlen (ansp->param[2]) + padding;
  test_case = (char *) mem_calloc (tmpsize, sizeof (char));

  sprintf (test_case, "%s(%s,%s)", ansp->api_name, ansp->param[0],
	   ansp->param[1]);

  retval = (size_t) mblen (ansp->param[0], atoi (ansp->param[1]));
  tmpsize = count_digit (retval) + 1;
  result_string = (char *) mem_calloc (tmpsize, sizeof (char));
  sprintf (result_string, "%d", retval);

  result = stringeq (result_string, ansp->result);
  display_result (ansp, test_case, result_string, ansp->result,
		  result, genans_flag, verbose_flag);

  mem_free ((void *) result_string);
  mem_free ((void *) test_case);

  return (result);
}

/*
 * TEST: size_t   wcslen( const wchar_t *ws )
 */
static boolean
wcslen_test ( answer * ansp,
	      wc_answer * wc_ansp,
	      boolean genans_flag,
	      boolean verbose_flag )
{
  int i;
  char *test_case;
  char *result_string;
  wchar_t *result_wstring;
  boolean result;
  size_t retval;
  size_t tmpsize;
  size_t padding = 20;

  tmpsize = stringlen (ansp->api_name) + stringlen (ansp->param[0]) + stringlen (ansp->param[1]) + stringlen (ansp->param[2]) + padding;
  test_case = (char *) mem_calloc (tmpsize, sizeof (char));

  sprintf (test_case, "%s(%s)", ansp->api_name, ansp->param[0]);

  retval = wcslen (wc_ansp->param[0]);
  tmpsize = count_digit (retval) + 1;
  result_string = (char *) mem_calloc (tmpsize, sizeof (char));
  sprintf (result_string, "%d", retval);

  result = stringeq (result_string, ansp->result);
  display_result (ansp, test_case, result_string, ansp->result,
		  result, genans_flag, verbose_flag);
  mem_free ((void *) result_string);

  mem_free ((void *) test_case);

  return (result);
}
