/*
 *
 * This software is subject to the terms of the IBM Public License.
 * You must accept the terms of this license to use this software.
 *
 *  Copyright (C) 2000, International Business Machines Corporation
 * and others.  All Rights Reserved.
 *
 *  Version : 1.0 (2000-07-12)
 *
 *  Author  :   Tadayuki Yoshida <tadayuki@jp.ibm.com>
 *
 */
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>

#include "test_mbtowc.h"

/***********************************************************
*                                                          *
* int getparams ( int argc,                                *
*                 char **argv,                             *
*                 params *paramp )                         *
*                                                          *
************************************************************/

int
getparams_mbtowc (int argc, char *argv[], params * paramp)
{
  int opt;
  boolean interactive = true;
  char *charmap_file;
  char *repertoiremaps_file;

  paramp->genans_global = false;
  paramp->prompt_flag = false;
  paramp->verbose_flag = true;
  paramp->input_fp = (FILE *) NULL;
  paramp->ans_fp   = (FILE *) NULL;

  charmap_file        = (char *) NULL;
  repertoiremaps_file = (char *) NULL;

  while ((opt = getopt (argc, argv, "if:a:hpvsl")) != -1)
    {
      switch (opt)
	{
	case 'i':
	  {
	    interactive = true;
	    break;
	  }
	case 'f':
	  {
	    interactive = false;
	    stringpcpy (&charmap_file, optarg);
	    break;
	  }
	case 'a':
	  {
	    stringpcpy (&repertoiremaps_file, optarg);
	    break;
	  }
	case 'h':
	  {
	    print_help_mbtowc ();
	    exit (0);
	    break;
	  }
	case 'p':
	  {
	    paramp->prompt_flag = true;
	    break;
	  }
	case 'v':
	  {
	    paramp->verbose_flag = true;
	    break;
	  }
	case 's':
	  {
	    paramp->verbose_flag = false;
	    break;
	  }
	case 'l':
	  {
	    print_supported_API ();
	    exit (0);
	    break;
	  }
	case '?':
	  {
	    fprintf (stderr, "unknown option %c\n", opt);
	    break;
	  }
	}
    }

  if (interactive)
    {
      paramp->input_fp = stdin;
    }
  else if (charmap_file)
    {
      if (NULL == (paramp->input_fp = fopen (charmap_file, "r")))
	{
	  fprintf (stderr, "could not open file: %s \n", charmap_file);
          mem_free ((void *) charmap_file);
	  exit (1);
	}
      mem_free ((void *) charmap_file);
    }
  else
    {
      fprintf (stderr, "No input file was specified.\n");
      exit (1);
    }

  if (repertoiremaps_file)
    {
      if (NULL == (paramp->ans_fp = fopen (repertoiremaps_file, "r")))
	{
	  fprintf (stderr, "could not open file: %s \n", repertoiremaps_file);
          mem_free ((void *) repertoiremaps_file);
	  exit (1);
	}
      mem_free ((void *) repertoiremaps_file);
    }

  return (optind);
}
