/*
 *
 * This software is subject to the terms of the IBM Public License.
 * You must accept the terms of this license to use this software.
 *
 *  Copyright (C) 2000, International Business Machines Corporation
 * and others.  All Rights Reserved.
 *
 *  Version : 1.0 (2000-07-12)
 *
 *  Author  :   Tadayuki Yoshida <tadayuki@jp.ibm.com>
 *
 */
#include <stdio.h>
#include "glibctest.h"

/*************************************************************
*                                                            *
*  void print_help ( void )                                  *
*                                                            *
**************************************************************/

void
print_help_mbtowc (void)
{
  char progname[] = PROGRAM_NAME;

  printf ("\n");
  printf ("Usage: interactive and batch mode.\n");
  printf ("  (interactive mode): %s [-i][-gvps]\n", progname);
  printf ("  (batch mode)      : %s [-vs] -f charmap-file [-a repertoiremap-file]\n", progname);
  printf ("\n");
  printf ("  -i                    interactive mode.\n");
  printf ("  -f charmap-file       read repertoiremap definition file.\n");
  printf ("  -a repertoiremap-file read charmap definition file.\n");
  printf ("  -h                    show this help.\n");
  printf ("  -p                    print prompt (for interactive mode).\n");
  printf ("  -v                    verbose output.\n");
  printf ("  -s                    silent output.\n");
  printf ("  -l                    print supported APIs in %s.\n", progname);
  printf ("\n");
  printf (COPYRIGHT_FORM);
  printf ("\n");
  printf ("\n");
}
