/*
 *
 * This software is subject to the terms of the IBM Public License.
 * You must accept the terms of this license to use this software.
 *
 *  Copyright (C) 2000, International Business Machines Corporation
 * and others.  All Rights Reserved.
 *
 *  Version : 1.0 (2000-07-12)
 *
 *  Author  :   Tadayuki Yoshida <tadayuki@jp.ibm.com>
 *
 */
#ifndef _REPERTOIRE_H_
#define _REPERTOIRE_H_

#include <limits.h>
#include <stdio.h>
#include <stdlib.h>
#include "hash.h"

typedef int unicode_t ;

#define UNICODE_LEN 4

typedef struct _repertoiremapdata {
  char *symbol;
  char *code;
} repertoiremapdata;

typedef struct _repertoiremap {
  char escape_char;
  char comment_char;
  FILE *fp;
  hashtable *hashtable;
} repertoiremap;

extern repertoiremap * repertoiremap_init ( FILE * );
extern void resolv_unicode ( const repertoiremap *, const char *, unicode_t * );
extern void repertoiremap_create ( repertoiremap * );
extern void repertoiremap_display ( repertoiremap * );
extern void repertoiremap_free ( repertoiremap * );

#endif
