/*
 *
 * This software is subject to the terms of the IBM Public License.
 * You must accept the terms of this license to use this software.
 *
 *  Copyright (C) 2000, International Business Machines Corporation
 * and others.  All Rights Reserved.
 *
 *  Version : 1.0 (2000-07-12)
 *
 *  Author  :   Tadayuki Yoshida <tadayuki@jp.ibm.com>
 *
 */
#include "test_mbtowc.h"

static boolean mbtowc_test ( answer *, wc_answer *, boolean, boolean );
static boolean wctomb_test ( answer *, wc_answer *, boolean, boolean );

void
api_table_create ( const api_table *tp )
{
  api_table_add (tp, "mbtowc", mbtowc_test);
  api_table_add (tp, "wctomb", wctomb_test);
}

/**********************************************************************
*                                                                     *
*                         INTERACTIVE MODE                            *
*                                                                     *
***********************************************************************/

/*
 * TEST: int  mbtowc ( wchar_t *pwc, const char *s, size_t n )
 */

static boolean
mbtowc_test ( answer * ansp,
	      wc_answer * wc_ansp,
	      boolean genans_flag,
	      boolean verbose_flag )
{
  char *test_case;
  char result_string[MB_LEN_MAX+1] = "";
  wchar_t wc;
  int ret;
  boolean result;
  size_t tmpsize;
  size_t padding = 32;
  char code[MB_LEN_MAX+1] = "";

  ul2xstr (ansp->param[0], code);

  tmpsize = stringlen (ansp->api_name) + stringlen (ansp->param[0]) + stringlen (ansp->param[1]) + stringlen (ansp->param[2]) + padding;
  test_case = (char *) mem_calloc (tmpsize, sizeof (char));

  sprintf (test_case, "mbtowc(&wc,%s[x%s],%s)",
	   ansp->param[0], code, ansp->param[1]);
  ret = mbtowc (&wc, ansp->param[0], (size_t)atoi(ansp->param[1]));
  if (ret < 0)
    {
      fprintf (stderr, OOPSSTR);
      fprintf (stderr, "%s returns %d.\n", test_case, ret);
      result = false;
    }
  else
    {
      result = (wc_ansp->result[0] == wc);
      sprintf (result_string, "%lc", wc);
      display_result (ansp, test_case, result_string, ansp->result,
                      result, genans_flag, verbose_flag);
    }
  mem_free ((void *) test_case);

  return (result);
}

/*
 * TEST: int  wctomb ( char *s, wchar_t wc )
 */

static boolean
wctomb_test ( answer * ansp,
	      wc_answer * wc_ansp,
	      boolean genans_flag,
	      boolean verbose_flag )
{
  char *test_case;
  char result_string[MB_LEN_MAX+1] = "";
  wchar_t wc;
  int ret;
  boolean result;
  size_t tmpsize;
  size_t padding = 30;

  tmpsize = stringlen (ansp->api_name) + stringlen (ansp->param[0]) + stringlen (ansp->param[1]) + stringlen (ansp->param[2]) + padding;
  test_case = (char *) mem_calloc (tmpsize, sizeof (char));

  sprintf (test_case, "wctomb(mbs,<U%04X>[%s])",
	   wc_ansp->param[0][0],ansp->param[0]);
  ret = wctomb (result_string, wc_ansp->param[0][0]);
  if (ret < 0)
    {
      fprintf (stderr, OOPSSTR);
      fprintf (stderr, "%s returns %d.\n", test_case, ret);
      result = false;
    }
  else
    {
      result = stringeq (result_string, ansp->result);
      display_result (ansp, test_case, result_string, ansp->result,
		      result, genans_flag, verbose_flag);
    }
  mem_free ((void *) test_case);

  return (result);
}

#define MBTOWC 0
#define WCTOMB 1
int
test_apis_mbtowc ( const charmap * cmp, const repertoiremap * rpp, api_table *tp, params *prmp )
{
  answer *ansp[2];
  wc_answer *wc_ansp[2];

  int i, j;
  char *ulvalue;
  char *unicode;
  unicode_t codevalue;
  charmapdata *ptr;
  int error_cnt = 0;
  boolean result;

  for (i = 0; !end_of_charmap (cmp, i); i++)
    {
      for (j = 0; j < 2; j++)
	{
	  ansp[j] = (answer *) mem_alloc (sizeof (answer));
	  wc_ansp[j] = (wc_answer *) mem_alloc (sizeof (wc_answer));
	}

      display_progress (i+1, cmp->listp->total_num);

      stringpcpy (&(ansp[MBTOWC]->api_name), "mbtowc");
      stringpcpy (&(ansp[WCTOMB]->api_name), "wctomb");

      ptr = (charmapdata *) cmp->listp->listp[i].datap;
      ulvalue = (char *) mem_calloc (cmp->mb_cur_max + 1, sizeof (char));
      xstr2ul (ptr->code, ulvalue);

      if (rpp)
	{
	  resolv_unicode (rpp, ptr->symbol, &codevalue);
	}
      else
	{
	  unicode = (char *) mem_calloc (UNICODE_LEN + 1, sizeof (char));
	  extract_unicode (ptr->symbol, unicode);
	  xstr2unicode (unicode, &codevalue);
	  mem_free ((void *) unicode);
	}

      /* for mbtowc */
      stringpcpy (&(ansp[MBTOWC]->param[0]), ulvalue);
      stringpcpy (&(ansp[MBTOWC]->result), ulvalue);
      ansp[MBTOWC]->param[1] = (char *) mem_calloc (3, sizeof (char));
      sprintf (ansp[MBTOWC]->param[1], "%d", cmp->mb_cur_max);
      stringpcpy (&(ansp[MBTOWC]->param[2]), "-");

      /* for wctomb */
      stringpcpy (&(ansp[WCTOMB]->param[0]), ulvalue);
      stringpcpy (&(ansp[WCTOMB]->result), ulvalue);
      stringpcpy (&(ansp[WCTOMB]->param[1]), "-");
      stringpcpy (&(ansp[WCTOMB]->param[2]), "-");

      convert_mbswcs (&(wc_ansp[MBTOWC]->api_name), ansp[MBTOWC]->api_name);
      convert_mbswcs (&(wc_ansp[WCTOMB]->api_name), ansp[WCTOMB]->api_name);

      wc_ansp[MBTOWC]->param[0] = (wchar_t *) mem_alloc (sizeof (wchar_t) * 2);
      wc_ansp[WCTOMB]->param[0] = (wchar_t *) mem_alloc (sizeof (wchar_t) * 2);
      wc_ansp[MBTOWC]->param[0][0] = codevalue;
      wc_ansp[MBTOWC]->param[0][1] = (wchar_t) NULL;
      wc_ansp[WCTOMB]->param[0][0] = codevalue;
      wc_ansp[WCTOMB]->param[0][1] = (wchar_t) NULL;

      mem_free ((void *) ulvalue);

      for (j = 1; j < PARAM_NUM; j++)
        {
          convert_mbswcs (&(wc_ansp[MBTOWC]->param[j]), ansp[MBTOWC]->param[j]);
          convert_mbswcs (&(wc_ansp[WCTOMB]->param[j]), ansp[WCTOMB]->param[j]);
        }

      wc_ansp[MBTOWC]->result = (wchar_t *) mem_alloc (sizeof (wchar_t) * 2);
      wc_ansp[WCTOMB]->result = (wchar_t *) mem_alloc (sizeof (wchar_t) * 2);
      wc_ansp[MBTOWC]->result[0] = codevalue;
      wc_ansp[MBTOWC]->result[1] = (wchar_t) NULL;
      wc_ansp[WCTOMB]->result[0] = codevalue;
      wc_ansp[WCTOMB]->result[1] = (wchar_t) NULL;

      result = true;
      for (j = 0; j < 2; j++)
	{
	  result &=
	    api_table_select (tp, ansp[j], wc_ansp[j], false, prmp->verbose_flag);
	}

      error_cnt += (result == false) ? 1 : 0;

      free_ans (ansp[MBTOWC], wc_ansp[MBTOWC]);
      free_ans (ansp[WCTOMB], wc_ansp[WCTOMB]);
    }
  
  result_report (i, error_cnt, "");

  return (0);
}
