/*
 *
 * This software is subject to the terms of the IBM Public License.
 * You must accept the terms of this license to use this software.
 *
 *  Copyright (C) 2000, International Business Machines Corporation
 * and others.  All Rights Reserved.
 *
 *  Version : 1.0 (2000-07-12)
 *
 *  Author  :   Tadayuki Yoshida <tadayuki@jp.ibm.com>
 *
 */
#include "test_mbtowc.h"

supported_API apilist[] = {
  {"mbtowc <mbchar> <mbsize> - <wchar>",
   "convert a multibyte sequence to a wide character."}
  ,
  {"wctomb <wchar> - - <mbchar>",
   "convert a wide character to a multibyte sequence."}
  ,
  {"\0", "\0"}
};

int
interactive_test ( api_table *tp, params *prmp )
{
  answer *ansp;
  wc_answer *wc_ansp;
  int case_cnt = 0;
  int error_cnt = 0;
  boolean result;

  int status;
  boolean genans_local = false;

  /*
   * Main Loop
   */
  while (true)
    {
      ansp = (answer *) mem_alloc (sizeof (answer));
      wc_ansp = (wc_answer *) mem_alloc (sizeof (wc_answer));

      print_prompt (prmp);
      status = input_reader (stdin, ansp, wc_ansp, &genans_local);
      if (status == (int) NULL)
	{
          mem_free ((void *)ansp);
          mem_free ((void *)wc_ansp);
	  break;
	}
      if (status == EMPTYLINE || status == INSUFFICIENTLINE)
	{
          mem_free ((void *)ansp);
          mem_free ((void *)wc_ansp);
	  continue;
	}

      result = api_table_select (tp, ansp, wc_ansp,
				 (genans_local || prmp->genans_global),
				 prmp->verbose_flag);
      error_cnt += (result == false) ? 1 : 0;
      case_cnt++;

      genans_local = false;
      free_ans (ansp, wc_ansp);
    }

  result_report (case_cnt, error_cnt, "");

  return (0);
}

int
main (int argc, char *argv[])
{
  int opt = 1;
  api_table *tp;
  charmap *cmp;
  params prm;
  repertoiremap *rpp;

  system_info ();

  /*
   * Option Check
   */

  getparams_mbtowc (argc, argv, &prm);

  /*
   * API test function register
   */

  tp = api_table_init (5);
  api_table_create (tp);

  if ( prm.input_fp == stdin )
    {
      interactive_test (tp, &prm);
    }
  else
    {
      /*
       * Charmap
       */
      cmp = charmap_init (prm.input_fp);
      fprintf (stderr, "scanned charmap (%d chars)\n",
	       cmp->listp->total_num);
      /*      charmap_display (cmp); */

      if (prm.ans_fp == (FILE *) NULL)
	{
	  rpp = (repertoiremap *) NULL;
	}
      else
	{
	  rpp = repertoiremap_init (prm.ans_fp);
	  repertoiremap_create (rpp);
	  fprintf (stderr, "scanned repertoiremaps (%d chars)\n",
		   rpp->hashtable->total_num);
	  /* repertoiremap_display (rpp); */
	}

      test_apis_mbtowc (cmp, rpp, tp, &prm);

      charmap_free (cmp);
      repertoiremap_free (rpp);
      fprintf (stderr, "\n");
    }

  api_table_free (tp);

  return (0);
}
