/*
 *
 * This software is subject to the terms of the IBM Public License.
 * You must accept the terms of this license to use this software.
 *
 *  Copyright (C) 2000, International Business Machines Corporation
 * and others.  All Rights Reserved.
 *
 *  Version : 1.0 (2000-07-19)
 *
 *  Author  :   Tadayuki Yoshida <tadayuki@jp.ibm.com>
 *
 */
#include "glibctest.h"
#include "test_printf.h"

static boolean printf_test ( answer *, wc_answer *, boolean, boolean );
static boolean sprintf_test ( answer *, wc_answer *, boolean, boolean );
#ifdef HAVE_SWPRINTF
static boolean swprintf_test ( answer *, wc_answer *, boolean, boolean );
#endif

void
api_table_create ( const api_table *tp )
{
  api_table_add (tp, "printf", printf_test);
  api_table_add (tp, "sprintf", sprintf_test);
#ifdef HAVE_SWPRINTF
  api_table_add (tp, "swprintf", swprintf_test);
#endif
}

/*
 * TEST: sprintf
 */

static boolean
printf_test ( answer * ansp,
	      wc_answer * wc_ansp,
	      boolean genans_flag,
	      boolean verbose_flag )
{
  boolean result;

  char *result_string;
  char *test_case;
  size_t tmpsize;
  size_t padding = 5;
  size_t ret;
  FILE *nullp;

  tmpsize = stringlen (ansp->api_name) + stringlen (ansp->param[0]) + stringlen (ansp->param[1]) + stringlen (ansp->param[2]) + padding;
  test_case = (char *) mem_calloc (tmpsize, sizeof (char));

  sprintf (test_case, "%s(%s,%s)", ansp->api_name, ansp->param[0],
	   ansp->param[1]);

  nullp = fopen ("/dev/null", "w");
  ret = fprintf (nullp, ansp->param[0], ansp->param[1]);
  tmpsize = ret + padding;

  result_string = (char *) mem_calloc (tmpsize, sizeof (char));
  sprintf (result_string, ansp->param[0], ansp->param[1]);

  result = stringeq (result_string, ansp->result);
  display_result (ansp, test_case, result_string, ansp->result,
		  result, genans_flag, verbose_flag);

  fclose (nullp);

  mem_free ((void *) test_case);
  mem_free ((void *) result_string);

  return (result);
}

/*
 * TEST: sprintf
 */

static boolean
sprintf_test ( answer * ansp,
	       wc_answer * wc_ansp,
	       boolean genans_flag,
	       boolean verbose_flag )
{
  boolean result;

  char *result_string;
  char *test_case;
  size_t tmpsize;
  size_t padding = 5;
  size_t ret;
  FILE *nullp;

  tmpsize = stringlen (ansp->api_name) + stringlen (ansp->param[0]) + stringlen (ansp->param[1]) + stringlen (ansp->param[2]) + padding;
  test_case = (char *) mem_calloc (tmpsize, sizeof (char));
  sprintf (test_case, "%s(%s,%s)", ansp->api_name, ansp->param[0],
	   ansp->param[1]);

  nullp = fopen ("/dev/null", "w");
  ret = fprintf (nullp, ansp->param[0], wc_ansp->param[1]);
  tmpsize = ret + padding;

  result_string = (char *) mem_calloc (tmpsize, sizeof (char));
  sprintf (result_string, ansp->param[0], wc_ansp->param[1]);

  result = stringeq (result_string, ansp->result);
  display_result (ansp, test_case, result_string, ansp->result,
		  result, genans_flag, verbose_flag);

  fclose (nullp);

  mem_free ((void *) test_case);
  mem_free ((void *) result_string);

  return (result);
}

/*
 * TEST: swprintf
 */

#ifdef HAVE_SWPRINTF
static boolean
swprintf_test ( answer * ansp,
		wc_answer * wc_ansp,
		boolean genans_flag,
		boolean verbose_flag )
{
  boolean result;

  wchar_t *result_string_w;
  char *result_string;
  char *test_case;
  size_t tmpsize;
  size_t padding = 5;
  size_t ret;
  FILE *nullp;

  tmpsize = stringlen (ansp->api_name) + stringlen (ansp->param[0]) + stringlen (ansp->param[1]) + stringlen (ansp->param[2]) + padding;
  test_case = (char *) mem_calloc (tmpsize, sizeof (char));
  sprintf (test_case, "%s(%s,%s)", ansp->api_name, ansp->param[0],
	   ansp->param[1]);

  nullp = fopen ("/dev/null", "w");
  ret = fwprintf (nullp, wc_ansp->param[0], ansp->param[1]);
  tmpsize = ret + padding;

  result_string_w = (wchar_t *) mem_calloc (tmpsize, sizeof (wchar_t));
  swprintf (result_string_w,
	    sizeof (result_string_w), wc_ansp->param[0], ansp->param[1]);

  convert_wcsmbs (&result_string, result_string_w);

  result = wstringeq (result_string_w, wc_ansp->result);
  display_result (ansp, test_case, result_string, ansp->result,
		  result, genans_flag, verbose_flag);

  fclose (nullp);

  mem_free ((void *) test_case);
  mem_free ((void *) result_string);
  mem_free ((void *) result_string_w);

  return (result);
}
#endif
