/*
 *
 * This software is subject to the terms of the IBM Public License.
 * You must accept the terms of this license to use this software.
 *
 *  Copyright (C) 2000, International Business Machines Corporation
 * and others.  All Rights Reserved.
 *
 *  Version : 1.0 (2000-07-19)
 *
 *  Author  :   Tadayuki Yoshida <tadayuki@jp.ibm.com>
 *
 */

#include "glibctest.h"
#include "test_printf.h"

supported_API apilist[] = {
  {"printf <format> <string> - <representation>",
   "format and print data."}
  ,
  {"sprintf <format> <Lstring> - <representation>",
   "formatted output conversion."}
  ,
  {"swprintf <Lformat> <string> <representation>",
   "formatted output conversion."}
  ,
  {"\0", "\0"}
};

/*
 *
 * int main()
 *
 */

int
main (int argc, char *argv[])
{
  answer *ansp;
  wc_answer *wc_ansp;
  api_table *tp;
  params prm;
  char progname[] = PROGRAM_NAME;
  int case_cnt = 0;
  int error_cnt = 0;
  boolean result;

  int status;
  boolean genans_local = false;

  system_info ();

  /*
   * Option search
   */

  getparams (argc, argv, &prm, progname);

  /*
   * API test function register
   */

  tp = api_table_init (10);
  api_table_create (tp);

  /*
   * Main Loop
   */
  while (true)
    {
      ansp = (answer *) mem_alloc (sizeof (answer));
      wc_ansp = (wc_answer *) mem_alloc (sizeof (wc_answer));

      print_prompt (&prm);
      status = input_reader (prm.input_fp, ansp, wc_ansp, &genans_local);
      if (status == (int) NULL)
	{
	  mem_free ((void *)ansp);
	  mem_free ((void *)wc_ansp);
	  fclose (prm.input_fp);
	  break;
	}
      if (status == EMPTYLINE || status == INSUFFICIENTLINE)
	{
	  mem_free ((void *)ansp);
	  mem_free ((void *)wc_ansp);
	  continue;
	}

      result = api_table_select (tp, ansp, wc_ansp,
				 (genans_local || prm.genans_global),
				 prm.verbose_flag);

      error_cnt += (result == false) ? 1 : 0;
      case_cnt++;

      genans_local = false;
      free_ans (ansp, wc_ansp);
    }

  api_table_free (tp);

  result_report (case_cnt, error_cnt, "");

  return (0);

}
