/*
 *
 * This software is subject to the terms of the IBM Public License.
 * You must accept the terms of this license to use this software.
 *
 *  Copyright (C) 2000, International Business Machines Corporation
 * and others.  All Rights Reserved.
 *
 *  Version : 1.0 (2000-07-19)
 *
 *  Author  :   Tadayuki Yoshida <tadayuki@jp.ibm.com>
 *
 */

#include "glibctest.h"
#include "test_string.h"

supported_API apilist[] = {
  {"wcwidth <wchar> - - <width>",
   "determine columns needed for a wide character."}
  ,
  {"wcswidth <wchars> <size> - <width>",
   "determine columns needed for a fixed-size wide character string."}
  ,

  {"strcat <string> <string> - <string>",
   "concatenate two strings."}
  ,
  {"wcscat <wstring> <wstring> - <wstring>",
   "concatenate two wide-character strings."}
  ,
  {"strncat <string> <string> <size> <string>",
   "concatenate two strings with in n-characters."}
  ,
  {"wcsncat <wstring> <wstring> <size> <wstring>",
   "concatenate two wide-chacacter strings with in n-characters."}
  ,

  {"strchr <string> <char> - <string>",
   "locate character in string (first occurence)."}
  ,
  {"strrchr <string> <char> - <string>",
   "locate character in string (last occurence)."}
  ,
  {"wcschr <wstring> <wchar> - <wstring>",
   "locate wide-character in wide-character string (first occurence)."}
  ,
  {"wcsrchr <wstring> <wchar> - <wstring>",
   "locate wide-character in wide-character string (last occurence)."}
  ,

  {"strcmp <string> <string> - <value>",
   "compare two strings."}
  ,
  {"strncmp <string> <string> <size> <value>",
   "compare two strings (first <size> characters)."}
  ,
  {"wcscmp <wstring> <wstring> - <value>",
   "compare two wide-character strings."}
  ,
  {"wcsncmp <wstring> <wstring> <size> <value>",
   "compare two wide-character strings (first <size> characters)."}
  ,

  {"strspn <string> <accept> - <value>",
   "search a string for a set of characters."}
  ,
  {"wcsspn <wstring> <accept> - <value>",
   "search a string for a set of characters."}
  ,

  {"strcspn <string> <reject> - <value>",
   "search a string for a set of characters."}
  ,
  {"wcscspn <wstring> <reject> - <value>",
   "search a wide-character string for a set of wide characters."}
  ,

  {"strstr <string> <string> - <string>",
   "locate a substring."}
  ,
  {"wcswcs <wstring> <wstring> - <wstring>",
   "locate s wide-character string."}
  ,

  {"strpbrk <string> <accept> - <value>",
   "search a string for any of a set of characters."}
  ,
  {"wcspbrk <string> <accept> - <value>",
   "search a wide-character string for any of a set of wide characters."}
  ,

  {"strtok <string> <delim> - <token>",
   "extract tokens from strings."}
  ,
  {"strtok_r <string> <delim> - <token>",
   "extract tokens from strings."}
  ,
  {"wcstok <wstring> <wdelim> - <wtoken>",
   "split wide-character string into tokens."}
  ,

  {"\0", "\0"}
};

/*
 *
 * main( )
 *
 */

int
main (int argc, char *argv[])
{
  answer *ansp;
  wc_answer *wc_ansp;
  api_table *tp;
  params prm;
  char progname[] = PROGRAM_NAME;
  int case_cnt = 0;
  int error_cnt = 0;
  boolean result;

  int status;
  boolean genans_local = false;

  system_info ();

  /*
   * Option search
   */

  getparams (argc, argv, &prm, progname);

  /*
   * API test function register
   */

  tp = api_table_init (30);
  api_table_create (tp);

  /*
   * Main Loop
   */
  while (true)
    {
      ansp = (answer *) mem_alloc (sizeof (answer));
      wc_ansp = (wc_answer *) mem_alloc (sizeof (wc_answer));

      print_prompt (&prm);
      status = input_reader (prm.input_fp, ansp, wc_ansp, &genans_local);
      if (status == (int) NULL)
	{
	  mem_free ((void *)ansp);
	  mem_free ((void *)wc_ansp);
	  fclose (prm.input_fp);
	  break;
	}
      if (status == EMPTYLINE || status == INSUFFICIENTLINE)
	{
	  mem_free ((void *)ansp);
	  mem_free ((void *)wc_ansp);
	  continue;
	}

      result = api_table_select	(tp, ansp, wc_ansp,
				 (genans_local || prm.genans_global),
				 prm.verbose_flag);
      error_cnt += (result == false) ? 1 : 0;
      case_cnt++;

      genans_local = false;
      free_ans (ansp, wc_ansp);
    }

  api_table_free (tp);

  result_report (case_cnt, error_cnt, "");

  return (0);
}
