#!/bin/sh

PACKAGE=glibctest
COREVER=1.1-0
GTKVER=1.0-0

WORKDIR=`pwd`
if test "$1" = "--without-gtk"; then
 GTKDIR=
else
 GTKDIR=$PACKAGE-gtk-$GTKVER
fi

COREDIR=$PACKAGE-$COREVER
CORE=$COREDIR.tar.gz

echo "--- Phase 1. Building Tool Core ---"
echo "  extracting $CORE ..."
gzip -cd $CORE | tar xf -
echo "  configuring tool ... (see $COREDIR/configure.log)"
cd $COREDIR
./configure > confiugre.log 2>&1
echo "  building tool core ... (see $COREDIR/make.log)" 
make > make.log 2>&1
echo "--- Phase 1 End ---"
cd $WORKDIR 

if [ "$GTKDIR" = "" ] ; then
  echo "skip GTK Build Phase."
else
GTK=$GTKDIR.tar.gz
echo "--- Phase 2. Building GTK GUI ---"
echo "  extracting $GTK ..."
gzip -cd $GTK | tar xf -
echo "  configuring GTK ... (see $GTKDIR/configure.log)"
cd $GTKDIR
./configure > configure.log 2>&1
echo "  building GTK GUI ... (see $GTKDIR/src/make.log)" 
cd src && make > make.log 2>&1
echo "--- Phase 2 End ---"
cd $WORKDIR
fi

echo "Building Phase(s) Completed."
echo "Now you just run \`sh runtest.sh'"
