#!/bin/sh

# Setup ppp

PPPDIR="/etc/ppp"
TMPDIR="/tmp/.pppsetup.$$"

check_uid () {
	if [ "$UID" != "0" ]; then
		dialog --title "ERROR" \
			--msgbox "\nroot ¤Ǥʤȼ¹ԤǤޤ\n" 7 70
		exit 1
	fi
}

check_ppp () {
	if [ ! -d "$PPPDIR" ]; then
		dialog --title "ERROR" \
			--msgbox "\nPPP 󥹥ȡ뤵Ƥޤ\n" 7 70
		exit 1
	fi
}

check_addr () {
	local RET=0 PIECE REST="$1." IDX=4

	while [ $IDX -ne 0 ]; do
		PIECE="${REST%%.*}"
		REST="${REST#*.}"
		if [ $((PIECE)) = "$PIECE" ]; then
			if [ $PIECE -lt 0 -o $PIECE -gt 255 ]; then
				RET=2   # illegal field
			fi
		else
			RET=2     # illegal field
		fi
		IDX=$((IDX - 1))
	done
	if [ -n "$REST" ]; then
		RET=1       # too many fields
	fi
	if [ $RET -ne 0 ]; then
		dialog --title "ERROR" --msgbox "`cat <<-EOF

				Ϥ줿($1)ϡIPɥ쥹ǤϤޤ

				Ǥϡ192.168.1.1 Τ褦ˡ4Ĥ0255οͤꤹɬפ
				ޤƤǧξ塢⤦ϤľƤ
 
			EOF`" 10 70
	fi
	return $RET
}

check_planet () {
	if [ -L "/etc/rc.d/rc.inet1" ]; then
		test "`ls -l '/etc/rc.d/rc.inet1' | sed 's/.*-> *//'`" = "rc.inet1.planet"
	else
		test -x "/etc/rc.d/rc.ifctl"
	fi
}

make_dir () {
	if [ ! -d "$2" ]; then
		mkdir -p "$2"
		chown 0.0 "$2"
		chmod $1 "$2"
	fi
}

make_file () {
	if [ ! -r "$2" ]; then
		touch "$2"
		chown 0.0 "$2"
		chmod $1 "$2"
	fi
}

init_pppdir () {
	make_dir 755 $PPPDIR/chat
	make_dir 755 $PPPDIR/peers
	make_dir 755 $PPPDIR/resolv
	make_file 600 $PPPDIR/pap-secrets
	make_file 600 $PPPDIR/chap-secrets
}

make_adv_vars () {
	ADV_VARS="HIDDEN DEBUG PPPDOPTS LINKNAME"
	if [ "$PPPTYPE" = "Dialup" ]; then
		ADV_VARS="$ADV_VARS MODEMINIT DIALTYPE AUTHTYPE"
		if [ "$1" != "CHAP/PAP" ]; then
			ADV_VARS="$ADV_VARS STARTCMD"
		fi
	fi
	ADV_VARS="$ADV_VARS DOMAIN DNS"
}

make_vars () {
	VARS="COMMENT DEVICE"
	if [ "$PPPTYPE" = "Dialup" ]; then
		VARS="$VARS TELNO"
	fi
	VARS="$VARS USERID PASSWD"

	make_adv_vars all
}

set_default () {
	COMMENT=
	PPPTYPE="Dialup"
	DEVICE=
	TELNO=
	USERID=
	PASSWD=
}

set_adv_default () {
	HIDDEN="Off"
	DEBUG="Off"

	if [ "$PPPTYPE" = "PPPoE" ]; then
		PPPDOPTS=
	else
		PPPDOPTS="modem crtscts"
	fi

	LINKNAME="common"
	MODEMINIT="E1"
	DIALTYPE="Tone"
	AUTHTYPE="CHAP/PAP"
	STARTCMD=
	DOMAIN=
	DNS=
}

read_config () {
	local SCRIPT ARGS

	CONFIG="$1"

	SCRIPT="`sed -e "/^#:/!d" -e "s/^#://" < $PPPDIR/peers/$CONFIG`"
	# decide PPPTYPE value first
	set_default
	eval "$SCRIPT"
	set_adv_default
	eval "$SCRIPT"

	USERID_ORIG="$USERID"

	if [ "$AUTHTYPE" = "Login" ]; then
		eval "ARGS=(`grep \"^assword:\" $PPPDIR/chat/$CONFIG`)"
		PASSWD="${ARGS[1]}"
	else
		eval "ARGS=(`grep \"^'$USERID' '$CONFIG'\" $PPPDIR/pap-secrets`)"
		PASSWD="${ARGS[2]}"
	fi
}

write_config () {
	local ONLYDEBUG DEBUGOPT ONLYPPPOE DEVICEOPT ONLYDIAL DIALOPT
	local LINKNAMEOPT="${LINKNAME:+linkname \"$LINKNAME\"}"
	local UNLESSDNS="${DNS:+#}"

	init_pppdir

	if [ "$DEBUG" = "On" ]; then
		ONLYDEBUG=
		DEBUGOPT="-v "
	else
		ONLYDEBUG="#"
		DEBUGOPT=
	fi


	if [ "$PPPTYPE" = "PPPoE" ]; then
		ONLYPPPOE=
		DEVICEOPT="nic-$DEVICE"
		ONLYDIAL="#"
	else
		ONLYPPPOE="#"
		DEVICEOPT="$DEVICE"
		ONLYDIAL=

		case "$DIALTYPE" in
		Tone)
			DIALOPT="T"
			;;
		Pulse)
			DIALOPT="P"
			;;
		*)
			DIALOPT=
			;;
		esac

		cat <<-EOF > $PPPDIR/chat/$CONFIG
			TIMEOUT         3
			ABORT           BUSY
			ABORT           'NO ANSWER'
			ABORT           'RINGING\r\n\r\nRINGING'
			''              AT&F
			OK-AT-OK        AT$MODEMINIT
			TIMEOUT         60
			OK              ATD$DIALOPT$TELNO
			CONNECT         '\d\c'
		EOF

		if [ "$AUTHTYPE" = "Login" ]; then
			cat <<-EOF >> $PPPDIR/chat/$CONFIG
				ogin:--ogin:    '$USERID'
				assword:        '$PASSWD'
				''              '\d\c'
			EOF
			if [ -n "$STARTCMD" ]; then
				echo "''              '$STARTCMD'" >> $PPPDIR/chat/$CONFIG
			fi
			chmod 600 $PPPDIR/chat/$CONFIG
		else
			chmod 644 $PPPDIR/chat/$CONFIG
		fi
	fi

	cat <<-EOF > $PPPDIR/peers/$CONFIG
		# Generated by pppsetup
		# Please do not delete any of the comments!
		#
		#:COMMENT="$COMMENT"
		#:PPPTYPE="$PPPTYPE"
		#:DEVICE="$DEVICE"
		#:TELNO="$TELNO"
		#:USERID="$USERID"
		#:HIDDEN="$HIDDEN"
		#:DEBUG="$DEBUG"
		#:PPPDOPTS="$PPPDOPTS"
		#:LINKNAME="$LINKNAME"
		#:MODEMINIT="$MODEMINIT"
		#:DIALTYPE="$DIALTYPE"
		#:AUTHTYPE="$AUTHTYPE"
		#:STARTCMD="$STARTCMD"
		#:DOMAIN="$DOMAIN"
		#:DNS="$DNS"
		${ONLYDEBUG}debug
		${ONLYPPPOE}plugin rp-pppoe.so
		$DEVICEOPT
		${ONLYDIAL}115200
		noipdefault
		defaultroute
		${UNLESSDNS}usepeerdns
		${ONLYDIAL}connect "/usr/sbin/chat $DEBUGOPT-f $PPPDIR/chat/$CONFIG"
		noauth
		name "$USERID"
		remotename "$CONFIG"
		ipparam "$CONFIG"
		$LINKNAMEOPT
		$PPPDOPTS
	EOF

	chmod 644 $PPPDIR/peers/$CONFIG

	if [ "$AUTHTYPE" = "CHAP/PAP" ]; then
		for f in $PPPDIR/pap-secrets $PPPDIR/chap-secrets; do
			grep -v "^'$USERID_ORIG' '$CONFIG'" < $f > $f.N
			echo "'$USERID' '$CONFIG' '$PASSWD'" >> $f.N
			mv -f $f.N $f
			chmod 600 $f
		done
	fi

	if [ -n "$DOMAIN" ]; then
		echo "search $DOMAIN" > $PPPDIR/resolv/$CONFIG
	else
		echo -n > $PPPDIR/resolv/$CONFIG
	fi
	for s in $DNS; do
		echo "nameserver $s" >> $PPPDIR/resolv/$CONFIG
	done
}

delete_config () {
	read_config "$1"

	rm -f $PPPDIR/peers/$CONFIG $PPPDIR/chat/$CONFIG $PPPDIR/resolv/$CONFIG

	for f in $PPPDIR/pap-secrets $PPPDIR/chap-secrets; do
		grep -v "^'$USERID_ORIG' '$CONFIG'" < $f > $f.N
		mv -f $f.N $f
		chmod 600 $f
	done
}

config_comment () {
	local _COMMENT

	_COMMENT=$(dialog --title "³" --inputbox "`cat <<-EOF

			³δñϤƤ

			³:
		EOF`" 11 72 3>&1 1>&2 2>&3) || return 1
	COMMENT_NEW=${_COMMENT}
	MODIFIED_NEW="yes"
}

config_device () {
	local _DEVICE

	while [ 0 ]; do
		if [ "$PPPTYPE" = "PPPoE" ]; then
			_DEVICE=$(dialog --title "ǥХ [PPPoE]" --menu "`cat <<-EOF

					³˻ȤͥåȥǥХ򤷤Ƥ
 
				EOF`" 14 72 5 \
				"eth0"  "1Ĥɸ।ͥåȥǥХ" \
				"eth1"  "2Ĥɸ।ͥåȥǥХ" \
				"wlan0" "̵LANǥХ" \
				"ath0"  "Atheros̵LANǥХ" \
				"Other" "¾" 3>&1 1>&2 2>&3) || return 1
		else
			_DEVICE=$(dialog --title "ǥХ [Dialup]" --menu "`cat <<-EOF

					³˻ȤꥢǥХ򤷤Ƥ
 
				EOF`" 17 72 8 \
				"/dev/modem"       "ɸޤ PCMCIA³ΥꥢǥХ" \
				"/dev/ttyS0"       "1ĤɸॷꥢǥХ" \
				"/dev/ttyS1"       "2ĤɸॷꥢǥХ" \
				"/dev/usb/ttyACM0" "USB³Υǥ" \
				"/dev/usb/ttyUSB0" "USB³ΥꥢǥХ" \
				"/dev/ttyLT0"      "Lucent Winǥ" \
				"/dev/ttySL0"      "SmartLink Winǥ" \
				"Other"            "¾" 3>&1 1>&2 2>&3) || return 1
		fi

		if [ "$_DEVICE" = "Other" ]; then
			_DEVICE=$(dialog --title "ǥХ" --inputbox "`cat <<-EOF

					³˻ȤǥХ̾ϤƤ

					ǥХ̾:
				EOF`" 11 72 3>&1 1>&2 2>&3) || continue
			if [ -z "$_DEVICE" ]; then
				continue
			fi
		fi

		if [ "$PPPTYPE" = "PPPoE" ]; then
			if /sbin/ifconfig "$_DEVICE" > /dev/null 2>&1; then
				break
			fi

			dialog --title "ERROR" --msgbox "`cat <<-EOF

					$_DEVICE ȤͥåȥǥХ¸ߤޤ

					ɥ饤Ф⥸塼벽Ƥϡmodprobeޥɤʤɤǥ
					饤ФɤơͥåȥǥХǧƤɬפ
					ޤ

					оݤӥɥ饤Фǧξ塢⤦ľƤ
 
				EOF`" 13 70
		else
			case "$_DEVICE" in
			/dev/*)
				if [ -r "$_DEVICE" ]; then
					break
				fi
				;;
			esac

			dialog --title "ERROR" --msgbox "`cat <<-EOF

					$_DEVICE ȤǥХե¸ߤޤ

					餫ᡢǥХե mknod ǺäƤǥХե
					ؤΥܥå󥯤ĥäƤɬפޤ

					оݤǧξ塢⤦ľƤ
 
				EOF`" 12 70
		fi
	done
	DEVICE_NEW="$_DEVICE"
	MODIFIED_NEW="yes"
}

config_telno () {
	local _TELNO=

	while [ -z "$_TELNO" ]; do
		_TELNO=$(dialog --title "ֹ" --inputbox "`cat <<-EOF

				PPP ³ֹϤƤ

				ֹ:
			EOF`" 11 72 3>&1 1>&2 2>&3) || return 1
	done
	TELNO_NEW="$_TELNO"
	MODIFIED_NEW="yes"
}

config_userid () {
	local _USERID=

	while [ -z "$_USERID" ]; do
		_USERID=$(dialog --title "桼ID" --inputbox "`cat <<-EOF

				PPP ³Ѥ桼ID ꤷƤ

				桼ID:
			EOF`" 11 72 3>&1 1>&2 2>&3) || return 1
	done
	USERID_NEW="$_USERID"
	MODIFIED_NEW="yes"
}

config_passwd () {
	local _PASSWD=

	while [ -z "$_PASSWD" ]; do
		_PASSWD=$(dialog --title "ѥ" --inputbox "`cat <<-EOF

				PPP ³ѤѥɤꤷƤ

				ѥ ($USERID_NEW):
			EOF`" 11 72 3>&1 1>&2 2>&3) || return 1
	done
	PASSWD_NEW="$_PASSWD"
	MODIFIED_NEW="yes"
}

config_hidden () {
	local _HIDDEN

	_HIDDEN=$(dialog --title "ȥ" --menu "`cat <<-EOF

			³򱣤ȥˤޤ? ȥˤȡpon -i 
			pon -ix Ǥ³˥塼󼨤ʤʤޤ

			PPPoE ǼưŪ³ϡȥˤ
			⤷ޤ
 
		EOF`" 15 72 2 \
		"Off" "ȥˤʤ" \
		"On"  "ȥˤ" 3>&1 1>&2 2>&3) || return 1
	HIDDEN_NEW="$_HIDDEN"
	MODIFIED_NEW="yes"
}

config_debug () {
	local _DEBUG

	_DEBUG=$(dialog --title "ǥХå⡼" --menu "`cat <<-EOF

			ǥХå⡼ɤͭˤޤ? ǥХå⡼ɤǤϡƥ
			(/var/log/messages )¿ξ󤬵Ͽޤ

			ޤ³ǤʤͭˤƤߤȡ¿ξ
			뤿ᡢϤ䤹ʤޤ
 
		EOF`" 15 72 2 \
		"Off" "ǥХå⡼̵" \
		"On"  "ǥХå⡼ͭ" 3>&1 1>&2 2>&3) || return 1
	DEBUG_NEW="$_DEBUG"
	MODIFIED_NEW="yes"
}

config_pppdopts () {
	local _PPPDOPTS

	_PPPDOPTS=$(dialog --title "pppd ץ" --inputbox "`cat <<-EOF

			pppd Фɲåץ󤬤ϤƤ

			ꥢݡȤΥǥѤ뤫ɤؼ "modem",
			"local"ӡեˡؼ "crtscts", "nocrtscts",
			"xonxoff"ޤPPP Υإå̵̤ˤ "novj" 䡢MRU 
			 MTU ؼ "mru", "mtu" pppd Ǥ¿Υץ
			ꤹ뤳ȤǤޤܺ٤ pppd Υޥ˥奢򻲾ȤƤ

			ɬפʤϡ[Enter] 򲡤Ƥ

			ǥޥ:
		EOF`" 19 72 3>&1 1>&2 2>&3) || return 1
	PPPDOPTS_NEW="$_PPPDOPTS"
	MODIFIED_NEW="yes"
}

config_linkname () {
	local _LINKNAME

	_LINKNAME=$(dialog --title "̾" --inputbox "`cat <<-EOF

			³Ф̾ϤƤ

			̾ϡpppd εư "/var/run/ppp-(̾).pid"
			̾ǡPIDե뤿ѤޤPPP ˥
			ġ뤫åեƻ뤹ˡꤷƤ
			Ǥ(衢/var/lock ʲ˺륷ꥢǥХΥåե
			ꤹ뤳Ȥ¿äΤǤǤϡˤäƥ
			ǥХѤþޤ)ʤϥåե
			ǤϤޤΤǡ¾ˤѤޤ

			ɬפʤϡ[Enter] 򲡤Ƥ

			̾:
		EOF`" 21 72 3>&1 1>&2 2>&3) || return 1
	LINKNAME_NEW="$_LINKNAME"
	MODIFIED_NEW="yes"
}

config_modeminit () {
	local _MODEMINIT

	_MODEMINIT=$(dialog --title "ǥޥ" --inputbox "`cat <<-EOF

			ǥޥɤϤƤƬ "AT" 
			Ǥ

			ɬפʤϡ[Enter] 򲡤Ƥ

			ǥޥ:
		EOF`" 14 72 3>&1 1>&2 2>&3) || return 1
	MODEMINIT_NEW="$_MODEMINIT"
	MODIFIED_NEW="yes"
}

config_dialtype () {
	local _DIALTYPE

	_DIALTYPE=$(dialog --title "ˡ" --menu "`cat <<-EOF

			ˡ򤷤Ƥ̾ Tone ǹޤ
 
		EOF`" 12 72 3 \
		"Tone"  "ȡ(ץå)" \
		"Pulse" "ѥ륹()" \
		"ISDN"  "ISDN" 3>&1 1>&2 2>&3) || return 1
	DIALTYPE_NEW="$_DIALTYPE"
	MODIFIED_NEW="yes"
}

config_authtype () {
	local _AUTHTYPE

	_AUTHTYPE=$(dialog --title "ǧˡ" --menu "`cat <<-EOF

			PPP³ǧˡ򤷤Ƥ̾ CHAP/PAP ǹޤ
			󤬡Ť ISP ǤϡǧڤѤƤ礬ޤ

			ʤCHAP  PAP ϡ³Ŭ򤷤ޤ
 
		EOF`" 14 72 2 \
		"CHAP/PAP" "CHAPǧ ޤ PAPǧ (ư)" \
		"Login"    "ǧ" 3>&1 1>&2 2>&3) || return 1
	AUTHTYPE_NEW="$_AUTHTYPE"

	if [ "$AUTHTYPE_NEW" = "Login" ]; then
		dialog --title "NOTICE" --msgbox "`cat <<-EOF

				ǧڤ򤵤ޤΤǡѥɤľ chatץ
				($PPPDIR/chat/$CONFIG) ˽񤭹ޤޤ

				 chatץȤϡѡ桼ʳǤɤʤ褦ꤵ
				ޤΤᡢpppd  root  setuid ƤƤ⡢̥桼
				¤³뤳ȤϤǤޤ

				³ϡsudo Ѥľ root ¤Ǽ¹Ԥɬפޤ
				chatץȤ root  setuid 뤳ȤϴǤΤǡФ
				Ƥ
 
			EOF`" 16 70
	fi

	MODIFIED_NEW="yes"
}

config_startcmd () {
	local _STARTCMD

	_STARTCMD=$(dialog --title "¹ԥޥ" --inputbox "`cat <<-EOF

			륢åץˡ⡼ȥޥǼ¹Ԥ륳ޥɤ
			ϤƤ㤨С³褬ñʤ륷󥵡
			ӥǤ硢 PPP ǡưɬפޤ

			ɬפʤϡ[Enter] 򲡤Ƥ

			¹ԥޥ:
		EOF`" 15 72 3>&1 1>&2 2>&3) || return 1
	STARTCMD_NEW="$_STARTCMD"
	MODIFIED_NEW="yes"
}

config_domain () {
	local _DOMAIN

	_DOMAIN=$(dialog --title "ɥᥤ̾" --inputbox "`cat <<-EOF

			PPP³˻Ȥɥᥤ̾ISP ؼƤϡ
			ꤷƤ

			ɥᥤ̾ꤷʤϡ[Enter] 򲡤Ƥ

			ɥᥤ̾:
		EOF`" 14 72 3>&1 1>&2 2>&3) || return 1
	DOMAIN_NEW="$_DOMAIN"
	MODIFIED_NEW="yes"
}

config_dns () {
	local INDEX=1 NS _DNS=

	while [ 0 ]; do
		case $INDEX in
		1)
			NS=$(dialog --title "͡ॵ(1)" --inputbox "`cat <<-EOF

					1ܤΥ͡ॵФ IPɥ쥹ꤷƤ

					PPP³˥͡ॵФξưŪ˼ϡ[Enter] 
					Ƥ

					͡ॵ(1) IPɥ쥹:
				EOF`" 14 72 3>&1 1>&2 2>&3) || return 1
			;;
		2)
			NS=$(dialog --title "͡ॵ(2)" --inputbox "`cat <<-EOF

					2ܤΥ͡ॵФ IPɥ쥹ꤷƤ

					(ѤΥ͡ॵ: $_DNS)

					ʾ͡ॵФ̵ϡ[Enter] 򲡤Ƥ

					͡ॵ(2) IPɥ쥹:
				EOF`" 15 72 3>&1 1>&2 2>&3) || return 1
			;;
		*)
			break
			;;
		esac
		if [ -z "$NS" ]; then
			break
		fi
		if check_addr "$NS"; then
			_DNS="$_DNS${_DNS:+ }$NS"
			INDEX=`expr $INDEX + 1`
		fi
	done
	DNS_NEW="$_DNS"
	MODIFIED_NEW="yes"
}

advanced_menu () {
	local ARGS ENTRIES SELECT _ADV_VARS="$ADV_VARS" MODIFIED_NEW="$MODIFIED"

	for v in $ADV_VARS; do
		vv="${v}_NEW"
		local "$vv"="${!v}"
	done

	while [ 0 ]; do
		ARGS=()
		make_adv_vars "$AUTHTYPE_NEW"
		for v in $ADV_VARS; do
			ARGS[${#ARGS[@]}]="$v"
			vv="${v}_NEW"
			ARGS[${#ARGS[@]}]="${!vv}"
		done
		ADV_VARS="$_ADV_VARS"
		ENTRIES=`expr ${#ARGS[@]} / 2`

		SELECT=$(dialog --title "ܺ: $CONFIG [$PPPTYPE]" --menu "`cat <<-EOF

				ѹܤ򤷤Ƥ

				ߤо: $CONFIG [$PPPTYPE]
 
			EOF`" `expr $ENTRIES + 13` 72 `expr $ENTRIES + 2` \
			"${ARGS[@]}" \
			"---"  "---" \
			"Exit" "" 3>&1 1>&2 2>&3) || return 1

		case "$SELECT" in
		Exit)
			for v in $ADV_VARS; do
				vv="${v}_NEW"
				eval "$v=\"${!vv}\""
			done
			MODIFIED="$MODIFIED_NEW"

			break
			;;
		---)
			;;
		*)
			eval "config_`echo $SELECT | tr A-Z a-z`"
			;;
		esac
	done
}

advanced_config () {
	local MODIFIED="$MODIFIED_NEW"

	for v in $ADV_VARS; do
		vv="${v}_NEW"
		local "$v"="${!vv}"
	done
	advanced_menu || return 1
	for v in $ADV_VARS; do
		vv="${v}_NEW"
		eval "$vv=\"${!v}\""
	done
	MODIFIED_NEW="$MODIFIED"
}

edit_menu () {
	local ARGS ENTRIES SELECT _PASSWD MODIFIED_NEW="$MODIFIED"

	for v in $VARS $ADV_VARS; do
		vv="${v}_NEW"
		local "$vv"="${!v}"
	done

	while [ 0 ]; do
		_PASSWD="$PASSWD_NEW"
		PASSWD_NEW="********"

		ARGS=()
		for v in $VARS; do
			ARGS[${#ARGS[@]}]="$v"
			vv="${v}_NEW"
			ARGS[${#ARGS[@]}]="${!vv}"
		done
		ENTRIES=`expr ${#ARGS[@]} / 2`

		PASSWD_NEW="$_PASSWD"

		SELECT=$(dialog --title "ѹ: $CONFIG [$PPPTYPE]" --menu "`cat <<-EOF

				ѹܤ򤷤Ƥ

				ߤо: $CONFIG [$PPPTYPE]
 
			EOF`" `expr $ENTRIES + 14` 72 `expr $ENTRIES + 3` \
			"${ARGS[@]}" \
			"---"      "---" \
			"Advanced" "ܺ" \
			"Exit"     "λ" 3>&1 1>&2 2>&3) || return 1

		case "$SELECT" in
		Advanced)
			advanced_config
			;;
		Exit)
			for v in $VARS $ADV_VARS; do
				vv="${v}_NEW"
				eval "$v=\"${!vv}\""
			done
			MODIFIED="$MODIFIED_NEW"

			break
			;;
		---)
			;;
		*)
			eval "config_`echo $SELECT | tr A-Z a-z`"
			;;
		esac
	done
}

confirm_menu () {
	local TEL LINES SELECT

	while [ -n "$MODIFIED" ]; do
		if [ "$PPPTYPE" = "PPPoE" ]; then
			TEL=
			LINES=19
		else
			TEL="\n  ֹ:   $TELNO"
			LINES=20
		fi
		SELECT=$(dialog --title "ǧ: $CONFIG [PPPoE]" --menu "`cat <<-EOF

				Ƥ³¸ƤǤ?

				  ³̾:     $CONFIG [$PPPTYPE]
				  ³: $COMMENT
				  ǥХ:   $DEVICE$TEL
				  桼ID:   $USERID
 
			EOF`" $LINES 72 5 \
			"Save"     "¸ƽλ" \
			"Quit"     "¸˽λ" \
			"---"      "---" \
			"Advanced" "ܺ" \
			"Reedit"   "Խ" 3>&1 1>&2 2>&3) || return 1

		case "$SELECT" in
		Save)
			write_config
			break
			;;
		Quit)
			break
			;;
		Advanced)
			advanced_menu
			;;
		Reedit)
			edit_menu
			;;
		esac
	done
}

config_name () {
	while [ 0 ]; do
		if [ -z "$1" ]; then
			CONFIG=$(dialog --title "³" --inputbox "`cat <<-EOF

					³̾ϤƤ

					ɸ³ϡñ [Enter] 򲡤Ƥ

					³̾[default]:
				EOF`" 13 72 3>&1 1>&2 2>&3) || return 1
			CONFIG="${CONFIG:-default}"
		else
			CONFIG=$(dialog --title "ԡ: $1" --inputbox "`cat <<-EOF

					ԡ³̾ϤƤ

					ߤϡñ [Enter] 򲡤Ƥ

					³̾:
				EOF`" 13 72 3>&1 1>&2 2>&3) || return 1

			if [ -z "$CONFIG" ]; then
				return 1
			fi
		fi

		case "$CONFIG" in
		*/*)
			dialog --title "ERROR" --msgbox "`cat <<-EOF

					³̾ "/" ޤ뤳ȤϤǤޤ

					̤̾ϤľƤ
 
				EOF`" 9 70

			continue
			;;
		*~|*.orig|*.bak)
			dialog --title "ERROR" --msgbox "`cat <<-EOF

					Ϥ줿³̾ϡХååץեѤͽ󤵤Ƥޤ

					̤̾ϤľƤ
 
				EOF`" 9 70

			continue
			;;
		esac

		if [ -r "/etc/ppp/peers/$CONFIG" ]; then
			dialog --title "ERROR" --msgbox "`cat <<-EOF

					$CONFIG Ȥ̾³ϤǤ¸ߤޤ

					̤̾ϤľƤ
 
				EOF`" 9 70

			continue
		fi

		mkdir -p "$TMPDIR"
		touch "$TMPDIR/$CONFIG" > /dev/null 2>&1
		if [ ! -f "$TMPDIR/$CONFIG" ]; then
			rm -f "$TMPDIR/$CONFIG" > /dev/null 2>&1
			rmdir "$TMPDIR" > /dev/null 2>&1
			dialog --title "ERROR" --msgbox "`cat <<-EOF

					³̾ˡե̾ȤƵƤʤʸޤޤƤޤ

					̤̾ϤľƤ
 
				EOF`" 9 70

			continue
		fi
		rm -f "$TMPDIR/$CONFIG" > /dev/null 2>&1
		rmdir "$TMPDIR" > /dev/null 2>&1

		break
	done
}

new_config () {
	config_name || return 1
	config_comment || return 1

	PPPTYPE=$(dialog --title "³μ" --menu "`cat <<-EOF

			³μ򤷤Ƥ
 
		EOF`" 11 72 2 \
		"Dialup" "륢å³" \
		"PPPoE"  "PPPoE³" 3>&1 1>&2 2>&3) || return 1

	config_device || return 1

	if [ "$PPPTYPE" = "PPPoE" ]; then
		if check_planet; then
			dialog --title "NOTICE" --msgbox "`cat <<-EOF

					$DEVICE_NEW Ǥ PPPoE 򤷤ޤ

					netconfig ǡPPPoE ѤԤʤäƤƤưŪ
					PPPoE ³ǤԤʤ褦ꤷϡܺ˥塼
					ΡHIDDENפͭˤ뤳Ȥǡpon -i ǤΥ˥塼
					˽Фʤ褦ˤ뤳ȤǽǤ

					롼ȤƻѤNAT ѥåȥե륿
					ɬפʾϡ/etc/rc.d/rc.inet1.sub ɲäƤ
 
				EOF`" 15 70
		else
			dialog --title "NOTICE" --msgbox "`cat <<-EOF

					$DEVICE_NEW Ǥ PPPoE 򤷤ޤ

					/etc/rc.d/rc.inet1 ǡʲΤ褦ꤷƤ

					  1:echo 1 > /proc/sys/net/ipv4/ip_forward
					  2:iptables -t nat -A POSTROUTING -o ppp0 -j MASQUERADE
					  3:iptables -A FORWARD -p tcp --tcp-flags SYN,RST SYN -j TCPMSS
					    --clamp-mss-to-pmtu
					  4:ifconfig $DEVICE_NEW up 0.0.0.0
					  5:pon $CONFIG

					롼ȤƻѤ硢13 (2ܤ NAT ȤΤ)
					ɬפǤѥåȥե륿ϡ3ܤθɲäƤ
					5ܤϡư˼ưŪ PPPoE ³ԤʤΤɬפǤ
					ξ硢ܺ˥塼ΡHIDDENפͭˤ뤳Ȥǡ
					pon -i ǤΥ˥塼˽Фʤ褦ˤ뤳ȤǽǤ
 
				EOF`" 22 70
		fi
	else
		config_telno || return 1
	fi

	config_userid || return 1
	config_passwd || return 1

	make_vars
	for v in $VARS; do
		vv="${v}_NEW"
		eval "$v=\"${!vv}\""
	done
	set_adv_default

	USERID_ORIG="$USERID"
	MODIFIED="yes"

	confirm_menu || return 1
}

select_menu () {
	local SELECT

	SELECT=$(dialog --title "$1" --menu "`cat <<-EOF

			³ $1 ФꤷƤ
 
		EOF`" 12 72 3 \
		"Edit"   "Խ" \
		"Copy"   "ԡ" \
		"Delete" "" 3>&1 1>&2 2>&3) || return 1

	case "$SELECT" in
	Edit)
		MODIFIED=
		read_config "$1"
		make_vars
		edit_menu || return 1
		confirm_menu || return 1
		;;
	Copy)
		read_config "$1"
		config_name "$1" || return 1
		write_config
		;;
	Delete)
		dialog --title "ǧ" --yesno "`cat <<-EOF

				³ $1 ƤǤ?
				ϼäȤǤޤ
 
			EOF`" 8 71 || return 1

		delete_config "$1"
		;;
	esac
}

init_config () {
	dialog --title "PPP " --yesno "`cat <<-EOF

			륢å³ޤ PPPoE³ޤ

			 $PPPDIR ʲ¸ޤǺ³
			̾ ponޥɤ˻ꤹ뤳ȤǡPPP³򳫻ϤǤޤǤ
			 poffޥɤ¹ԤƤ

			̥桼 PPP³Ĥϡsudo Ѥ root ¤
			¹Ԥ뤫pppd  root  setuid ƥ롼פǤμ¹Ը¤Ĵ
			뤫Ƥ

			򳫻ϤƤǤ?
 
		EOF`" 17 71 || return 1

	new_config || return 1
}

main_menu () {
	local STARTUP="yes" ARGS CONFIG COMMENT HEADING ENTRIES SELECT

	while [ 0 ]; do
		ARGS=()
		for f in $PPPDIR/peers/*; do
			if [ -f "$f" ]; then
				CONFIG="${f##*/}"
				read_config "$CONFIG"
				if [ "$HIDDEN" = "On" ]; then
					HEADING="-"
				else
					HEADING="+"
				fi
				case "$CONFIG" in
				*~|*.orig|*.bak)
					;;
				default)
					if [ -n "$COMMENT" ]; then
						COMMENT="$COMMENT (ɸ³)"
					else
						COMMENT="ɸ³"
					fi
					ARGS=("${HEADING}default" "$COMMENT" "${ARGS[@]}")
					;;
				*)
					ARGS[${#ARGS[@]}]="${HEADING}$CONFIG"
					ARGS[${#ARGS[@]}]="$COMMENT"
					;;
				esac
			fi
		done
		if [ ${#ARGS[@]} -gt 0 ]; then
			ARGS=("${ARGS[@]}" "---" "---")
		elif [ -n "$STARTUP" ]; then
			init_config || exit
			continue
		fi

		STARTUP=
		ENTRIES=`expr ${#ARGS[@]} / 2`
		if [ $ENTRIES -gt 12 ]; then
			ENTRIES=12
		fi
		SELECT=$(dialog --title "PPP " --menu "`cat <<-EOF

				³򤷤Ƥ
				³ԤʤϡNew 򤷤Ƥ
 
			EOF`" `expr $ENTRIES + 11` 72 `expr $ENTRIES + 1` \
			"${ARGS[@]}" \
			"New" "³" 3>&1 1>&2 2>&3) || exit

		case "$SELECT" in
		New)
			new_config
			;;
		---)
			;;
		*)
			select_menu "${SELECT#[-+]}"
			;;
		esac
	done
}

check_uid
check_ppp
main_menu

# Local Variables:
# tab-width: 2
# sh-indentation: 2
# End:
