//
// Copyright (C) 1999-2002 Toshikaz Hirabayashi
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// TOSHIKAZ HIRABAYASHI BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
// WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF
// OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
// Except as contained in this notice, the name of Toshikaz Hirabayashi shall
// not be used in advertising or otherwise to promote the sale, use or other
// dealings in this Software without prior written authorization from
// Toshikaz Hirabayashi.

#ifndef WSCVDB_H
#define WSCVDB_H

#include <WScom.h>
#include <WSCngbase.h>

#define WSCvdb_VER  1000

class WSCdbDatabase;
class WSCdbRecord;

class WSCvdb   :public WSCngbase{

  protected:
    WSCdbDatabase* _db;
    char*   _hostname;
    char*   _user;
    char*   _passwd;
    char*   _dbname;
    WSCushort _port; 
    WSCuchar  _type;

    WSMFpropertyDef(WSNhostname,    char*, _hostname);
    WSMFpropertyDef(WSNusername,    char*, _user);
    WSMFpropertyDef(WSNpassword,    char*, _passwd);
    WSMFpropertyDef(WSNdbname,    char*, _dbname);
    WSMFpropertyDef(WSNport,    WSCushort, _port);
    WSMFpropertyDef(WSNtype,    WSCuchar, _type);

  public:
    void _init();
    WSCdbDatabase* getDBDatabase();

    WSCvdb(WSCbase* base, char* name);
    virtual ~WSCvdb();

    long open(char* hostname,char* uid,char* passwd,char* dbname= NULL,char* port = NULL);
    long open();
    long close();
    WSCbool isOpen();
    long sqlExecute(const char*);
    long beginTran();
    long commitTran();
    long abortTran();

    void getErrorMsg(char* msg,long size);
    WSCstring getErrorMessage();

    WSMFguiClassDef(WSCvdb,WSCngbase);
    WSMFversionDef(WSCvdb);
};

#endif //WSCVDB_H
