/*
 * Decompiled with CFR 0.152.
 */
package writer2latex.util;

import java.util.Hashtable;
import writer2latex.util.Misc;
import writer2latex.util.SimpleInputBuffer;

public class ExportNameCollection {
    private Hashtable exportNames = new Hashtable();
    private String sPrefix;
    private boolean bAcceptNumbers;

    public ExportNameCollection(String string, boolean bl) {
        this.sPrefix = string;
        this.bAcceptNumbers = bl;
    }

    public ExportNameCollection(boolean bl) {
        this("", bl);
    }

    public void addName(String string) {
        char c;
        if (this.containsName(string)) {
            return;
        }
        StringBuffer stringBuffer = new StringBuffer();
        SimpleInputBuffer simpleInputBuffer = new SimpleInputBuffer(string);
        if (this.bAcceptNumbers && simpleInputBuffer.peekChar() >= '0' && simpleInputBuffer.peekChar() <= '9') {
            stringBuffer.append('a');
        }
        while ((c = simpleInputBuffer.peekChar()) != '\u0000') {
            if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z') {
                stringBuffer.append(simpleInputBuffer.getChar());
                continue;
            }
            if (c >= '0' && c <= '9') {
                if (this.bAcceptNumbers) {
                    stringBuffer.append(simpleInputBuffer.getInteger());
                    continue;
                }
                stringBuffer.append(Misc.int2roman(Integer.parseInt(simpleInputBuffer.getInteger())));
                continue;
            }
            simpleInputBuffer.getChar();
        }
        String string2 = stringBuffer.toString();
        while (this.exportNames.containsValue(string2)) {
            string2 = string2 + "a";
        }
        this.exportNames.put(string, string2);
    }

    public String getExportName(String string) {
        if (!this.containsName(string)) {
            this.addName(string);
        }
        return this.sPrefix + (String)this.exportNames.get(string);
    }

    public boolean containsName(String string) {
        return this.exportNames.containsKey(string);
    }

    public boolean isEmpty() {
        return this.exportNames.size() == 0;
    }
}

