### Name: GenericFunctions
### Title: Tools for Managing Generic Functions
### Aliases: GenericFunctions isGeneric isGroup removeGeneric
###   standardGeneric getGenerics allGenerics dumpMethod findFunction
###   dumpMethods removeMethods signature setReplaceMethod callGeneric
### Keywords: programming classes methods

### ** Examples

## Not run: 
##D   ## get the function "myFun" -- throw an error if 0 or > 1 versions visible
##D   allF <- findFunction("myFun")
##D   if(length(allF) == 0)
##D     stop("No versions of myFun visible")
##D   else if(length(allF) > 1)
##D     stop("myFun is ambiguous: ", length(allF), " versions")
##D   else
##D     fdef <- get("myFun", allF[[1]])
## End(Not run)

## Don't show: 
## because nosegfault runs standardGeneric w/o the methods package, nothing
## really gets tested.  The following check that it catches some errors
mustDie <- function(expr) stopifnot(is(trySilent(expr), "try-error"))

mustDie(standardGeneric()) # 3 tests of requiring a single string
mustDie(standardGeneric(NULL))
mustDie(standardGeneric(""))
mustDie(standardGeneric("notAGenericFunction"))
mustDie(standardGeneric("show"))  # a generic, but not called from its body

## End Don't show



