#!/bin/sh

SWNAME=bookview-3.2
MANDIR=/usr/share/man
INFODIR=/usr/share/info
DOCDIR=/usr/share/doc
ARCH=i386
BUILD=P1
PKG=${SWNAME}-${ARCH}-${BUILD}.tgz

rm -rf ${SWNAME}
tar zxf ${SWNAME}.tar.gz
cd ${SWNAME}
./configure --prefix=/usr --infodir=$INFODIR --mandir=$MANDIR
make

P=`pwd`/../pkg
rm -rf $P
mkdir -p ${P}${DOCDIR}/${SWNAME}
make install DESTDIR=$P
cp -p ../`basename $0` A* C* I* N* R* ${P}${DOCDIR}/${SWNAME}/.
chown -R root:root ${P}${DOCDIR}/${SWNAME}
rm ${P}${INFODIR}/dir
gzip ${P}${INFODIR}/*.info

cd $P
/sbin/makepkg $PKG <<EOF
y
y
EOF

mkdir -p install
cat >> install/doinst.sh <<EOF
#%% begin initialize $SWNAME
if [ -x /usr/bin/install-info ] ; then
 /usr/bin/install-info --info-dir=${INFODIR} ${INFODIR}/bookview.info.gz
 /usr/bin/install-info --info-dir=${INFODIR} ${INFODIR}/bookview-ja.info.gz
elif [ -x /usr/sbin/install-info ] ; then
 /usr/sbin/install-info --info-dir=${INFODIR} ${INFODIR}/bookview.info.gz
 /usr/sbin/install-info --info-dir=${INFODIR} ${INFODIR}/bookview-ja.info.gz
fi
#%% end
EOF
tar zcf $PKG usr install

