export PATH=/bin:/usr/bin:/sbin:/usr/sbin

groupadd jabber
useradd -g jabber -d /usr/var/jabberd jabber
mkdir -p $ROOT/usr/var/jabberd/{pid,log}
chown -R jabber:jabber $ROOT/usr/var/jabberd
chown -R jabber:jabber $ROOT/etc/jabberd
#chown -R jabber:jabber $ROOT/usr/etc/jabberd
#ln -sf $ROOT/usr/etc/jabberd $ROOT/etc/jabberd

cat >.mkrsakey.cfg <<EOT
[ req ]
default_bits                    = 1024
distinguished_name     = req_DN
prompt                 = no

[ req_DN ]
countryName                     = JP
stateOrProvinceName             = "Tokyo"
localityName                    = "Yokohama"
0.organizationName              = "LiNet"
organizationalUnitName          = "Plamo WG"
commonName                      = LOCALHOST
emailAddress                    = www@LOCALHOST
EOT

openssl req -config .mkrsakey.cfg -new -x509 -newkey rsa:1024 -days 3650 -keyout privkey.pem -out server.pem
openssl rsa -in privkey.pem -out privkey.pem
cat privkey.pem >> server.pem
rm -f privkey.pem
mv server.pem $ROOT/etc/jabberd/
chown root:jabber $ROOT/etc/jabberd/server.pem
chmod 640 $ROOT/etc/jabberd/server.pem

mkdir -p $ROOT/usr/var/jabberd/.postgresql 
cp $ROOT/opt/pgsql/data/server.crt $ROOT/usr/var/jabberd/.postgresql/postgresql.crt
cp $ROOT/opt/pgsql/data/server.key $ROOT/usr/var/jabberd/.postgresql/postgresql.key
chown -R jabber:jabber $ROOT/usr/var/jabberd/.postgresql
su postgres -c "createuser -A -R -D jabberd2"
su postgres -c "createdb -O jabberd2 -E UTF-8 -T template0 jabberd2"
su postgres -c "psql -U jabberd2 -f $ROOT/usr/share/doc/jabberd-2.1.10/db-setup.pgsql"

