<?php



/**
 * ページ更新時にメールを送るクラス。
 */
class Mail /* implements PageObserver */
{
	/**
	 * ページ更新と同時にメールを送る。
	 */
	static function update($page)
	{
		if(!MAIL_USE){
			return;
		}
		
		$pagename = $page->getpagename();
		if($page->getsource() == ''){
			$head = "「{$pagename}」が削除されました。";
		}
		else if($page->getsource(1) == ''){
			$head = "「{$pagename}」が作成されました。";
		}
		else{
			$head = "「{$pagename}」が変更されました。";
		}
		
		$diff = $page->diff(0, 1);
		$renderer = new DiffRenderer($diff);
		$source = $renderer->render(MAIL_DIFF);
		
		$subject = '[KinoWiki-' . WIKIID . "] $pagename";
		$text[] = $head;
		$text[] = '----------------------------------------------------------------------';
		$text[] = $source;
		sendmail($subject, join("\n", $text));
	}
}

?>