# -*- coding: UTF-8 -*-
#
#  aya5.py - a (Real) 文5 loader for ninix
#  Copyright (C) 2004 by linjian
#  Copyright (C) 2004, 2005 by Shyouzou Sugitani <shy@users.sourceforge.jp>
#
#  This program is free software; you can redistribute it and/or modify it
#  under the terms of the GNU General Public License (version 2) as
#  published by the Free Software Foundation.  It is distributed in the
#  hope that it will be useful, but WITHOUT ANY WARRANTY; without even the
#  implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
#  PURPOSE.  See the GNU General Public License for more details.
#

import os
import sys

try:
    import _aya5
except:
    _aya5 = None

class Shiori:

    def __init__(self, dll_name):
        self.dll_name = dll_name

    def use_saori(self, saori):
        self.saori = saori

    def find(self, dir, dll_name): ## FIXME
        result = 0
        if _aya5:
            if os.path.isfile(os.path.join(dir, 'aya5.txt')):
                result = 205
            elif dll_name is not None and os.path.isfile(os.path.join(dir, dll_name[:-3]+'txt')):
                result = 105
        return result

    def show_description(self):
        sys.stdout.write('Shiori: Real Aya5 loader for ninix\n'
                         '        Copyright (C) 2004 by linjian\n'
                         '        Copyright (C) 2004, 2005 by Shyouzou Sugitani\n')

    def get_charset(self, dir, dll_name): ## FIXME
        charset = 'Shift_JIS'
        file = open(os.path.join(dir, dll_name[:-3] + 'txt'))
        for line in file:
            pos = line.find('charset')
            if pos >= 0:
                charset = line.split(',')[1]
                charset = charset.strip()
                break
        if charset == 'default':
            charset = 'Shift_JIS'
        return charset

    def load(self, dir):
        self.dir = dir
        self.charset = self.get_charset(self.dir, self.dll_name)
        self.saori_list = {}
        if _aya5:
            reload(_aya5)
            if self.dir[-1] == os.sep:
                dir = self.dir
            else:
                dir = self.dir + os.sep
            _aya5.setcallback(self.saori_exist,
                              self.saori_load,
                              self.saori_unload,
                              self.saori_request)
            result = _aya5.load_aya5(dir)
            return result
        else:
            return 0

    def unload(self):
        if _aya5:
            _aya5.unload_aya5()
            for name in self.saori_list.keys():
                if self.saori_list[name][1]:
                    self.saori_list[name][0].unload()
                del self.saori_list[name]

    __req_charset = 'GET SHIORI/3.0\r\n' \
                    'ID: charset\r\n' \
                    'Sender: ninix-aya\r\n' \
                    'SecurityLevel: local\r\n\r\n'

    def request(self, req_string):
        if _aya5:
            if req_string == self.__req_charset:
                return 'SHIORI/3.0 200 OK\r\n' \
                       'Sender: AYA5\r\n' \
                       'Value: %s\r\n\r\n' % self.charset
            return _aya5.request_aya5(req_string)
        else:
            return '' # FIXME

    def saori_exist(self, saori):
        module = self.saori.request(saori)
        if module:
            self.saori_list[saori] = [module, 0]
            return len(self.saori_list)
        else:
            return 0

    def saori_load(self, saori, path):
        result = 0
        if self.saori_list.has_key(saori) and self.saori_list[saori][1] == 0:
            result = self.saori_list[saori][0].load(path)
            self.saori_list[saori][1] = result
        return result

    def saori_unload(self, saori):
        result = 0
        if self.saori_list.has_key(saori) and self.saori_list[saori][1] != 0:
            result = self.saori_list[saori][0].unload()
            self.saori_list[saori][1] = 0
        return result

    def saori_request(self, saori, req):
        result = 'SAORI/1.0 500 Internal Server Error'
        if self.saori_list.has_key(saori):
            if self.saori_list[saori][1] == 0:
                head, tail = os.path.split(saori)
                self.saori_list[saori][1] = self.saori_list[saori][0].load(head)
            if self.saori_list[saori][1]:
                result = self.saori_list[saori][0].request(req)
        return result
