<?php

/*
 *	W-AGORA 4.0
 *	-----------
 *	$Id: create_site.php5,v 1.60 2005/06/15 15:18:27 mdruilhe Exp $
 *	Usage:		Create a new site
 *	Author:		Marc Druilhe <mdruilhe@w-agora.net>
 */

$site = "agora";
require ("init_admin.inc");
# Check is safe_mode On
# ---------------------
	$sf = @get_cfg_var("safe_mode");

function error_die($msg, $delete_all=false) {
	global $new_site, $newsite_cfgfile, $newsite_db, $WA_SELF;

	if ($delete_all) {
		if (!empty($newsite_cfgfile)) {
			@unlink ("$newsite_cfgfile");	
		}

		if (is_object($newsite_db) && !empty($new_site)) {
			$newsite_db->deleteSite ("$new_site", "no");	
		}
	}

	display_header (LABEL_CREATE_SITE);
	msgForm ($msg, $WA_SELF, 'back');
	display_footer();
	exit;
}

function create_dir($dir) {
	global $sf, $ext, $WA_SELF;

# Check if safe_mode is On
# ------------------------

	if (@is_dir ($dir)) {
		$ret = true;
		$dir_created = false;
	} else {
		$ret = mkdir ("$dir", _DIRMODE);
		$dir_created = true;
	}

	if ($ret) {

		// Directory have been created, make sure we can create a file in it
		$perm = false;
		$fd = fopen ("$dir/tmp.$ext", "w+");
		if (!$fd) {
			if ($dir_created) {
			    rmdir($dir);
			}
			display_header (LABEL_CREATE_SITE);
			msgForm (sprintf (ERROR_SF_CREATE_FILE, $dir), "$WA_SELF", 'back');
			return false;
		}
		fputs ($fd, "<?php \$perm=true; ?" . '>');
		fclose ($fd);
		include "$dir/tmp.$ext";
		@unlink ("$dir/tmp.$ext");
		if ($perm) {
			return true;
		} else {
			if ($dir_created) {
			    rmdir($dir);
			}
			display_header (LABEL_CREATE_SITE);
			msgForm (sprintf (ERROR_SF_CREATE_FILE, $dir), "$WA_SELF", 'back');
			return false;
		}

	} else {

		// Could not create dir, try to figure out why.
		$msgerr = str_replace("{DIRECTORY}", $dir, ERROR_CREATE_DIR);
		if ($sf) {
			$msgerr .= str_replace("{DIRECTORY}", $dir, ERROR_SAFE_MODE);
		} else {
			$msgerr .= ERROR_NO_PERMISSIONS;
		}
		display_header (LABEL_CREATE_SITE);
		msgForm ($msgerr, "$WA_SELF", 'back');
		return false;
	}
}


# save agora main DB access type (set in init_admin)
# --------------------------------------------------
	$agora_dbaccess = $site_access;
	$agora_dbhost = $site_dbhost;
	$agora_dbport = $site_dbport;
	$agora_dbuser = $site_dbuser;
	$agora_dbpassword = $site_dbpassword;
	$agora_dbadmuser = $site_dbadmuser;
	$agora_dbadmpassword = $site_dbadmpassword;
	$agora_dbname = $site_dbname;

# Load site administration configuration
# --------------------------------------
require ("$site_cfg_file");
if (empty($bn_msgs) ) {
	include ("$bn_dir_default/site_msgs.$ext");
} else {
	include "$bn_dir/$bn_msgs";
}

# --------------------------------------------------
# check if this user is allowed to create a site
# --------------------------------------------------
if ($auth->level < ROOT) {
	display_header (LABEL_CREATE_SITE);
	$auth->login($site, ERROR_NO_ROOT);
	display_footer();
	exit;

}

# --------------------------------------------------
# FORM has been submitted => do installation
# --------------------------------------------------
if (isSet($do_setup)) {

	$newsite_name = strip_magic_quotes($_POST['newsite_name']);
	$newsite_title = strip_magic_quotes($_POST['newsite_title']);

	if ($mode=='advanced') {
		$newsite_dbaccess = strip_magic_quotes($_POST['newsite_dbaccess']);
		$newsite_dbhost = strip_magic_quotes($_POST['newsite_dbhost']);
		$newsite_dbport = strip_magic_quotes($_POST['newsite_dbport']);
		$newsite_dbuser = strip_magic_quotes($_POST['newsite_dbuser']);
		$newsite_dbpassword = strip_magic_quotes($_POST['newsite_dbpassword']);
		$newsite_dbadmuser = strip_magic_quotes($_POST['newsite_dbadmuser']);
		$newsite_dbadmpassword = strip_magic_quotes($_POST['newsite_dbadmpassword']);
		$newsite_dbname = strip_magic_quotes($_POST['newsite_dbname']);
		$newsite_dir_forums = strip_magic_quotes($_POST['newsite_dir_forums']);
		$newsite_search_engine = strip_magic_quotes($_POST['newsite_search_engine	']);
	} else {
		if ($mode=='setup') {
			$newsite_dbaccess = $agora_dbaccess;
			$newsite_dbhost = $agora_dbhost;
			$newsite_dbport = $agora_dbport;
			$newsite_dbuser = $agora_dbuser;
			$newsite_dbpassword = $agora_dbpassword;
			$newsite_dbadmuser = $agora_dbadmuser;
			$newsite_dbadmpassword = $agora_dbadmpassword;
			$newsite_dbname = $agora_dbname;
		} else {
			$newsite_dbaccess = strip_magic_quotes($_POST['newsite_dbaccess']);
			$newsite_dbhost = strip_magic_quotes($_POST['newsite_dbhost']);
			$newsite_dbport = "";
			$newsite_dbuser = strip_magic_quotes($_POST['newsite_dbuser']);
			$newsite_dbpassword = strip_magic_quotes($_POST['newsite_dbpassword']);
			$newsite_dbadmuser = $newsite_dbuser;
			$newsite_dbadmpassword = $newsite_dbpassword;
			$newsite_dbname = strip_magic_quotes($_POST['newsite_dbname']);
		}
		$newsite_dir_forums = $bn_dir_forums;
		$newsite_search_engine = "none";
	}

	if (empty($newsite_name)) {
		error_die (FORM_NO_SITE);
	} elseif (empty($newsite_title)){
		error_die (FORM_NO_DESCRIPTION);
	} elseif (empty($newsite_dbaccess)){
		error_die (FORM_NO_DBACCESS);
	} elseif (empty($newsite_dbname)){
		error_die (FORM_NO_DBNAME);
	} elseif (empty($newsite_dir_forums)){
		error_die (FORM_NO_DIRECTORY);
	}

	$new_site = ereg_replace ("[^[:alnum:]]+", "", $nq=strip_magic_quotes($nl=strtolower($newsite_name)));

	if (strlen ($new_site) > 32) {
		error_die (FORM_SITE_LONG);
	}

# Check if this site already exists in the site table
# ---------------------------------------------------
	$siteinfo = $db->getSite ($new_site);
	if (is_array($siteinfo) && $siteinfo['bn_name']== $new_site ) {
		error_die (str_replace("{SITE}", "(<tt>$new_site</tt>)", CHECK_SITE_EXISTS));
	}

# Check if configuration file already already exists
# --------------------------------------------------
	$newsite_cfgfile = "${cfg_dir}/site_${new_site}.${ext}";

	if (file_exists ("$newsite_cfgfile")) {
		error_die (sprintf(CHECK_CONFIG_EXISTS, $newsite_cfgfile));
	}

# Create directories
# ------------------
	// Create forum's directory
	if (! @is_dir ("$newsite_dir_forums")) {
		create_dir("$newsite_dir_forums") or die ('</BODY></HTML>');
	}

	// site directory
	$newsite_dir="$newsite_dir_forums/$new_site";

	if (! @is_dir ("$newsite_dir")) {
		create_dir("$newsite_dir") or die ('</BODY></HTML>');
		$site_dir_created = TRUE;
	}

	// default template directory
	if (! @is_dir ("$newsite_dir/default")) {
		create_dir("$newsite_dir/default") or die ('</BODY></HTML>');
	}

# Get admin user infos for later use (doing this before accessing the site database)
# ----------------------------------------------------------------------------------
	$admin_fields = $db->getUser("agora", "admin");
	if (!is_array($admin_fields) ) {
		error_die (ERROR_ADMIN_NOT_FOUND);
	}

# ---------------------------------------------------------------------------------------
# Open a new DB connection for this site (allows us to use a different database access)
#		$site_access = agora access
#		$db = agora "system" database
#		$newsite_db = site database
# ---------------------------------------------------------------------------------------
	if ($agora_dbaccess != $newsite_dbaccess) {
		include "$inc_dir/$newsite_dbaccess.$ext";
		$db_class = "${newsite_dbaccess}_access";
	}

	$db->closeDB();

	$newsite_dbadmuser = (empty($newsite_dbadmuser) ) ? $newsite_dbuser : $newsite_dbadmuser;
	$newsite_dbadmpassword = (empty($newsite_dbadmpassword) && ($newsite_dbadmuser==$newsite_dbuser) ) ? $newsite_dbpassword : $newsite_dbadmpassword;

	$newsite_db = new $db_class;
	$ret = $newsite_db->openDB($newsite_dbhost, $newsite_dbport, $newsite_dbadmuser, $newsite_dbadmpassword, $newsite_dbname, $new_site);
	if ($ret < 0) {
		error_die (ERROR_NO_DATABASE);
	}

	$newsite_db->setHaltOnError ('report');

# Read default site configuration File, initialize variables
# ----------------------------------------------------------
	$default_tmpl_dir = "$tmpl_dir/default/$newsite_theme_dir";

	if (file_exists ("$default_tmpl_dir/conf_site.$ext") ) {
		include ("$default_tmpl_dir/conf_site.$ext");
	} else {
		include ("$tmpl_dir/admin/conf_site.$ext");
	}


# Override values
# ---------------
	$site = $new_site;
	$bn_dir = $newsite_dir;
	$bn_dir_notes = $newsite_dir;
	$bn_dir_forums = $newsite_dir_forums;
	$bn_dir_default = "$newsite_dir/default";
	$dbname = $newsite_dbname;
	$bn_access = $newsite_dbaccess;
	$dbhost = $newsite_dbhost;
	$dbport = $newsite_dbport;
	$dbuser = $newsite_dbuser;
	$dbpassword = $newsite_dbpassword;
	$dbadmuser = $newsite_dbadmuser;
	$dbadmpassword = $newsite_dbadmpassword;
	$bn_usersource = $newsite_usersource;

	switch ($newsite_search_engine) {
	  case "swish":
		$bn_search_path="/usr/local/bin/swish";
	  break;
	  case "namazu":
		$bn_search_path="include/bn_namazu";
	  break;
	  default:
		$bn_search_path="";
		$bn_search=1;		// right now, search in site only available in database
	  break;
	}

# Copy all customization files
# ----------------------------

#  Copy all template files to the new site directory
#  -------------------------------------------------
	$files = array ("bn_fields", "bn_header", "bn_list_vars", "bn_footer", "bn_msgs", "bn_before_access");

	foreach ($files as $name) {
		$file = $$name;
		if (!empty ($file) ) {
			$ret = TRUE;
			if (file_exists ("$default_tmpl_dir/$file") ) {
				$ret = copy ("$default_tmpl_dir/$file", "$newsite_dir/$file");
			} elseif (file_exists ("$tmpl_dir/admin/$file") ) {
				$ret = copy ("$tmpl_dir/admin/$file", "$newsite_dir/$file");
			} else {
				$$name = "";
			}
			if (!$ret) {
				error_die (sprintf (ERROR_CREATE_FILE, "$newsite_dir/$file"));
			}
		}
	}

# Create site Configuration File
# ------------------------------
	$bn_registration_mode = $newsite_registration_mode;
	$conf = new Config;
	$ret=$conf->open("$newsite_cfgfile");
	if (!$ret) {
		error_die (sprintf (ERROR_CREATE_FILE, "$newsite_cfgfile") . ". " .  ERROR_NO_PERMISSIONS); /* access problem */
	}
	$conf->writeConfig();
	$conf->close ();


# Copy all default customization/layout files for this site (in sitename/default/)
# --------------------------------------------------------------------------------

	$dir = opendir("$default_tmpl_dir");
	while ( $file = readdir($dir) ) {
		if (is_file ("$default_tmpl_dir/$file") ) {
			copy ("$default_tmpl_dir/$file", "$newsite_dir/default/$file");
		}
	}
	closedir($dir);

# Create site forums table / DBM file
# -----------------------------------
	$bn_db = $new_site;

	if (file_exists ("$default_tmpl_dir/$bn_fields") ) {
		$fields_file = "$default_tmpl_dir/$bn_fields";
	} else {
		$fields_file = "$tmpl_dir/admin/$bn_fields";
	}

	$ret = $newsite_db->createSite ("$new_site", "$fields_file");

	if ($ret == -1) {
			$errmsg = str_replace("{SITE}", $new_site, str_replace("{DATABASE}", $dbname, ERROR_DB_EXISTS));
		error_die($errmsg);
	} elseif ($ret == ERR_ACCESS) {
		$errmsg = str_replace("{DATABASE}", $dbname, ERROR_DB_ACCESS);
		@unlink ("$newsite_cfgfile");
		error_die($errmsg);
	} elseif ($ret < 0) {
		@unlink ("$newsite_cfgfile");
		$errmsg = str_replace("{SITE}", $new_site, ERROR_CREATE_SITE);
		error_die($errmsg);
	}

	// Create attachments table
	// ------------------------
	include "$tmpl_dir/admin/att_fields.$ext";
	unset ($field_descr);
	foreach ($bn_var as $var) {
		$field_descr[$var] = $bn_var_size[$var];
	}
	$ret = $newsite_db->createTable ("${new_site}_attachments", $field_descr, 'att_id');

	if ($ret == -1) {
		msgWarning (str_replace("{TABLE}", "${new_site}_attachments", str_replace("{DATABASE}", $dbname, ERROR_TABLE_EXISTS)));
	} elseif ($ret == ERR_ACCESS) {
		error_die (str_replace("{DATABASE}", $dbname, ERROR_DB_ACCESS), true);
	} else {
		$newsite_db->createIndex ("${new_site}_attachments", 'note_id');
		$newsite_db->createIndex ("${new_site}_attachments", 'bn_name');
	}

	// Create site users table
	// -----------------------
	if (file_exists("$newsite_dir/default/user_fields.$ext") ) {
		include "$newsite_dir/default/user_fields.$ext";
	} else {
		include "$tmpl_dir/admin/user_fields.$ext";
	}

	unset ($field_descr);
	foreach ($user_var as $var) {
		$field_descr[$var] = $user_var_size[$var];
	}
	$ret = $newsite_db->createTable ("${new_site}_users", $field_descr, 'userid');
	if ($ret == -1) {
		msgWarning (str_replace("{TABLE}", "${new_site}_users", str_replace("{DATABASE}", $dbname, ERROR_TABLE_EXISTS)));
	} elseif ($ret == ERR_ACCESS) {
		error_die (str_replace("{DATABASE}", $dbname, ERROR_DB_ACCESS), true);
	}

	// Create user-forum table
	// -----------------------
	include "$tmpl_dir/admin/userforum_fields.$ext";
	unset ($field_descr);
	foreach ($bn_var as $var) {
		$field_descr[$var] = $bn_var_size[$var];
	}
	$ret = $newsite_db->createTable ("${new_site}_userforum", $field_descr, 'userid,bn_name');

	if ($ret == -1) {
		msgWarning (str_replace("{TABLE}", "${new_site}_userforum", str_replace("{DATABASE}", $dbname, ERROR_TABLE_EXISTS)));
	} elseif ($ret == ERR_ACCESS) {
		error_die (str_replace("{DATABASE}", $dbname, ERROR_DB_ACCESS), true);
	}

# Create user-thread subscription table
# -------------------------------------
	$ut_descr["bn_name"] = "64";
	$ut_descr["useraddress"] = "255";
	$ut_descr["thread"] = "INT";
	$ret = $newsite_db->createTable ("${new_site}_userthread", $ut_descr);

	if ($ret == -1) {
		msgWarning (str_replace("{TABLE}", "${new_site}_userthread", str_replace("{DATABASE}", $dbname, ERROR_TABLE_EXISTS)));
	} elseif ($ret == ERR_ACCESS) {
		error_die (str_replace("{DATABASE}", $dbname, ERROR_DB_ACCESS), true);
	} else {
		$newsite_db->createIndex ("${new_site}_userthread", 'bn_name');
		$newsite_db->createIndex ("${new_site}_userthread", 'thread');
	}

# inserts admin user (root) in the site users table
# -------------------------------------------------
	$ret = $newsite_db->insertUser ($new_site, $admin_fields);
	if ($ret < 0) {
		msgWarning (str_replace("{USER}", "admin", ERROR_CREATE_ADMIN));
	}

# inserts owner (if <> 'admin') in the site users table
# -----------------------------------------------------
	if ($auth->userid != 'admin') {
		$ret = $newsite_db->insertUser ($new_site, $auth->user);
		if ($ret < 0) {
			msgWarning (str_replace("{USER}", $auth->userid, ERROR_CREATE_ADMIN));
		}
	}

# inserts guest user in the site users table
# ------------------------------------------

	$guest_fields =	array (
		'userid' => 'guest',
		'password' => 'none',
		'username' => GUESTUSER_USERNAME,
		'useraddress' => GUESTUSER_USERADDRESS,
		'details' => GUESTUSER_DETAILS,
		'userpriv' => 'user',
		'state' => '0',
		'mailok' => 'N'
	);

	$ret = $newsite_db->insertUser ($new_site, $guest_fields);
	if ($ret < 0) {
		msgWarning (str_replace('{USER}', 'guest', str_replace('{TABLE}', "${new_site}_users", ERROR_CREATE_USER)), $WA_SELF, 'back');
	}


# Insert entry in the site table (used as main category)
# ------------------------------------------------------
	$fields["parent"] = 0;
	$fields["thread"] = 0;
	$fields["childs"] = 0;
	$fields["unixdate"] = $now;
	$fields["newest"] = $now;
	$fields["cle"] = 0;
	$fields["category"] = 1;
	$fields["rank"] = 1;
	$fields["bn_name"] = $new_site;
	$fields["bn_db"] = $new_site;
	$fields["bn_title"] = strip_magic_quotes($newsite_title);
	$fields["descr"] = strip_magic_quotes($newsite_descr);
	$fields["state"] = "1";
	$fields["type"] = "rest";
	$fields["moderated"] = 1;
	$fields["owner"] = "admin";

	$ret = $newsite_db->insertRow($new_site, $fields);


# Create LOG table (history + statistics)
# ---------------------------------------
	include "$tmpl_dir/admin/log_fields.$ext";
	unset ($field_descr);
	foreach ($bn_var as $var) {
		$field_descr[$var] = $bn_var_size[$var];
	}

	$ret = $newsite_db->createTable ("${new_site}_log", $field_descr);
	if ($ret == -1) {
		msgWarning (str_replace("{TABLE}", "${new_site}_log", str_replace("{DATABASE}", $dbname, ERROR_TABLE_EXISTS)));
	} elseif ($ret == ERR_ACCESS) {
		error_die (str_replace("{DATABASE}", $dbname, ERROR_DB_ACCESS), true);
	}

	$ret = $newsite_db->createTable ("${new_site}_log_t1", $field_descr);
	$ret = $newsite_db->createTable ("${new_site}_log_t2", $field_descr);
	$ret = $newsite_db->createTable ("${new_site}_log_t3", $field_descr);
	$ret = $newsite_db->createTable ("${new_site}_log_t4", $field_descr);

	$forumstat_descr = array(
		'year_stat' => 'INT',
		'month_stat' => 'INT',
		'day_stat' => 'DATETIME NOT NULL',
		'forum' => '64',
		'total_insert' => 'INT',
		'total_login' => 'INT',
		'total_view' => 'INT',
		'total_subscribe' => 'INT',
		'total_register' => 'INT'
	);

	$ret = $newsite_db->createTable ("${new_site}_dailyforumstats", $forumstat_descr);
	if ($ret == -1) {
		msgWarning (str_replace("{TABLE}", "${new_site}_dailyforumstats", str_replace("{DATABASE}", $dbname, ERROR_TABLE_EXISTS)));
	} elseif ($ret == ERR_ACCESS) {
		error_die (str_replace("{DATABASE}", $dbname, ERROR_DB_ACCESS), true);
	}
	$newsite_db->createIndex ("${new_site}_dailyforumstats", 'year_stat,month_stat,day_stat,forum', true, "${site}_dailyforumstats_uk");
	$newsite_db->createIndex ("${new_site}_dailyforumstats", 'day_stat,forum', true, "${site}_dailyforumstats_day");

	$userstat_descr = array(
		'year_stat' => 'INT',
		'month_stat' => 'INT NULL',
		'week_stat' => 'INT NULL',
		'day_stat' => 'DATETIME NULL',
		'total_users' => 'INT'
	);

	$ret = $newsite_db->createTable ("${new_site}_dailyuserstats", $userstat_descr);
	if ($ret == -1) {
		msgWarning (str_replace("{TABLE}", "${new_site}_dailyuserstats", str_replace("{DATABASE}", $dbname, ERROR_TABLE_EXISTS)));
	} elseif ($ret == ERR_ACCESS) {
		error_die (str_replace("{DATABASE}", $dbname, ERROR_DB_ACCESS), true);
	}
	$newsite_db->createIndex ("${new_site}_dailyuserstats", 'year_stat,month_stat,week_stat,day_stat', true, "${site}_dailyuserstats_uk");
	$newsite_db->createIndex ("${new_site}_dailyuserstats", 'day_stat');

# Create generic Custom menus table
# ---------------------------------
	$menus_descr["menu_name"] = "32";
	$menus_descr["menu_key"] = "32";
	$menus_descr["menu_value"] = "255";
	$ret = $newsite_db->createTable ("${new_site}_menus", $menus_descr, 'menu_name,menu_key');

	if ($ret == -1) {
		msgWarning (str_replace("{TABLE}", "${new_site}_menus", str_replace("{DATABASE}", $dbname, ERROR_TABLE_EXISTS)));
	} elseif ($ret == ERR_ACCESS) {
		error_die (str_replace("{DATABASE}", $dbname, ERROR_DB_ACCESS), true);
	}

# Now Insert entry for this site in the main (agora) database
# -----------------------------------------------------------
	$fields["totalnotes"] = 0;
	$fields["lastnote"] = $now;

# Re_open the main agora DB connection
# ------------------------------------
	$newsite_db->closeDB();
	$db->openDB($agora_dbhost, $agora_dbport, $agora_dbadmuser, $agora_dbadmpassword, $agora_dbname, "agora");
	$ret = $db->insertForum ("agora", $fields);
	if ($ret < 0) {
		$ret = $newsite_db->openDB($newsite_dbhost, $newsite_dbport, $newsite_dbadmuser, $newsite_dbadmpassword, $newsite_dbname, $new_site);
		error_die (ERROR_NO_ADD_SITE, true);
	}

	$success_msg ="<BR><BR><BLOCKQUOTE><font face='Arial, Geneva, Verdana, sans-serif' size='+1'><b> " . str_replace("{SITE}", $new_site, LABEL_CREATE_SITE_DONE) . "</b> <ul>";
	$success_msg .= "<li> " . anchor ("create_forum.$ext?site=$new_site", "", LABEL_CREATE_FORUM,  LABEL_CREATE_FORUM);
	$success_msg .= "<li> " . anchor ("create_site.$ext?site=agora", "", LABEL_CREATE_ANOTHER_SITE, LABEL_CREATE_ANOTHER_SITE);
	$success_msg .= "<li> " . anchor ("admin_site.$ext?site=$new_site", "", LABEL_ADMINISTRATE_SITE, LABEL_ADMINISTRATE_SITE);
	$success_msg .= "<li> " . anchor ("admin.$ext?site=", "", LABEL_SITE_MANAGEMENT, LABEL_SITE_MANAGEMENT);
	$success_msg .= "</ul></font></BLOCKQUOTE><BR><BR>";

	// $ret=$auth->authenticate ("admin", "", $admin_fields["password"], $new_site);
	display_header (LABEL_CREATE_SITE);
	table_header(str_replace("{SITE}", $newsite_name, CREATE_SITE_DONE));
	print ("$success_msg");
	table_footer();
	display_footer();
	exit;

} // End do_setup

display_header (LABEL_CREATE_NEW_SITE);

# Initialize defaults values
# --------------------------
	if (!isset($newsite_name)) {
		$newsite_name=strtok($SERVER_NAME,".");
		if ($newsite_name=="www") $newsite_name=strtok(".");
	}

	$default_theme_dir = "agora";
	$default_usersource = empty ($bn_usersource) ? "agora_user" : $bn_usersource;

	$newsite_dbaccess		= (isset($newsite_dbaccess)) ? $newsite_dbaccess : $agora_dbaccess;
	$newsite_dbname			= (isset($newsite_dbname)) ? $newsite_dbname : $agora_dbname;
	$newsite_dbhost			= (isset($newsite_dbhost)) ? $newsite_dbhost : $agora_dbhost;
	$newsite_dbport			= (isset($newsite_dbport)) ? $newsite_dbport : $agora_dbport;
	$newsite_dbuser			= (isset($newsite_dbuser)) ? $newsite_dbuser : $agora_dbuser;
	$newsite_dbadmuser		= (isset($newsite_dbadmuser)) ? $newsite_dbadmuser : "";
	$newsite_search_engine	= (isset($newsite_search_engine)) ? $newsite_search_engine : "none";
	$newsite_dir_forums		= (isset($newsite_dir_forums)) ? $newsite_dir_forums : $bn_dir_forums;
	$newsite_theme_dir		= (isset($newsite_theme_dir)) ? $newsite_theme_dir : $default_theme_dir;
	$newsite_usersource		= (isset($newsite_usersource)) ? $newsite_usersource : $default_usersource;
	$newsite_registration_mode = (isset($newsite_registration_mode)) ? $newsite_registration_mode : $bn_registration_mode;

# Get all available templates
# ---------------------------
	$dir = dir("$tmpl_dir/default");
	while ($entry=$dir->read() ) {
		if ( is_dir("$tmpl_dir/default/$entry") && ($entry != ".") && ($entry != "..") && ($entry != "CVS") ) {
			$desc="";
			if (file_exists ("$tmpl_dir/default/$entry/toc.$ext")) {
				include "$tmpl_dir/default/$entry/toc.$ext";
			}
			$theme_dirs[$entry] = (empty($desc)) ? $entry : $desc;
		}
	}
	$dir->close();
	$choose_theme_box = getListBox("newsite_theme_dir", $theme_dirs, $newsite_theme_dir, 0, "showimg(this);");

# Get all availables external authentication modules
# --------------------------------------------------
	$dir = dir($user_dir);
	while ($entry=$dir->read() ) {
		#only match those that end in _user.$ext
		$suffixpos = strpos(strtolower($entry), strtolower("_user.$ext"));
		if ( is_file("$user_dir/$entry") && ($suffixpos) ) {
			$extpos = strpos(strtolower($entry), strtolower(".$ext"));
			$filename = substr($entry, 0, $extpos);
			$user_classes[$filename] = substr($entry, 0,$suffixpos);
		}
	}
	$dir->close();

	$mode = (empty($mode)) ? "basic" : $mode;
	$default_mode = (empty($default_mode)) ? $mode : $default_mode;

//	Now displays form
//	-----------------
	if ($mode=="advanced") {
		$newmode_url = "<a href=\"create_site.$ext?mode=$default_mode&default_mode=$default_mode\" onClick=\"document.setupform.mode.value='$default_mode';document.setupform.submit();return false;\">" . LABEL_BASIC ."</a> &nbsp; ".  LABEL_ADVANCED;
	} else {
		$newmode_url = LABEL_BASIC . " &nbsp; <a href=\"create_site.$ext?mode=advanced&default_mode=$default_mode\" onClick=\"document.setupform.mode.value='advanced';document.setupform.submit();return false;\">" . LABEL_ADVANCED ."</a>";
	}
?>

<script LANGUAGE="JavaScript" type="text/javascript">
  function showimg(menu){
    var entry = menu.options[menu.selectedIndex].value;
    document.screenshot.src="<?php echo $tmpl_dir?>/default/"+entry+"/screenshot.jpg";
  }
</script>

<form id="setupform" name="setupform" action="<?php echo $wa_self?>" method="post">
<input type="hidden" name="mode" value="<?php echo $mode?>">
<input type="hidden" name="default_mode" value="<?php echo $default_mode?>">

<?php table_header(LABEL_CREATE_NEW_SITE, 600);?>

<p>
<fieldset>
 <legend><b><?php echo TITLE_GENERAL_SETTINGS ?></b></legend>
 <br>
 <table border="0" cellspacing="2" cellpadding="2" width="90%">
  <tr>
   <td width="40%" class="label"><strong><?php echo LABEL_SITE_NAME?> (*)</strong></td>
   <td><input type="text" name="newsite_name" size="30" value="<?php echo $newsite_name?>"></td>
  </tr>
  <tr>
   <td width="40%" class="label"><strong><?php echo LABEL_SITE_TITLE?> (*)</strong></td>
   <td><input type="text" name="newsite_title" size="30" value="<?php echo $newsite_title?>"></td>
  </tr>
  <tr>
   <td width="40%" class=label valign="top"><?php echo LABEL_SITE_DESCRIPTION?></td>
   <td><textarea name="newsite_descr" rows=2 cols=30 wrap='virtual'><?php echo $newsite_descr?></textarea></td>
  </tr>
   <tr>
   <td width="40%" class=label valign="top"><?php echo COLUMN_SITE_REGISTRATION_MODE?></td>
   <td><?php listbox("newsite_registration_mode", $registration_modes, $newsite_registration_mode);?></td>
  </tr>
 </table>
</fieldset>
<p>

<?php if ($mode!='setup') { ?>
<fieldset>
 <legend><b><?php echo LABEL_DB_PARAMETERS ?></b></legend>

   <table border="0" cellspacing="2" cellpadding="2" width="90%">
    <tr>
     <td width="40%" valign="middle" class="label"><strong><?php echo LABEL_DB_TYPE ?> (*)</strong> </TD>
     <td><?php listbox("newsite_dbaccess", $databases, $newsite_dbaccess)?></td>
	</tr>

    <tr>
     <td width="40%" valign="middle" class="label"><?php echo LABEL_DB_SERVER_NAME?></TD>
     <td><?php textField ("newsite_dbhost", $newsite_dbhost, 30, 80);?></td>
	</tr>

<?php	if ($mode=='advanced') { ?>
	<tr>
     <td width="40%" class="label"><?php echo LABEL_DB_SERVER_PORT ?></td>
     <td><?php textField ("newsite_dbport", $newsite_dbport, 30, 4);?></td>
    </tr>
<?php	} ?>

	<tr>
     <td width="40%" class="label"><strong><?php echo LABEL_DB_NAME ?> (*)</strong> </TD>
     <td><?php textfield ("newsite_dbname", $newsite_dbname, 30)?></td>
    </tr>

    <tr>
     <td width="40%" valign="middle" class="label"><strong><?php echo LABEL_DB_USER ?> (*)</strong></TD>
     <td><?php textfield ("newsite_dbuser", $newsite_dbuser, 30);?></td>
	</tr>

	<tr>
     <td width="40%" class="label"><?php echo LABEL_DB_PASSWORD ?></TD>
     <td><?php passwordField ("newsite_dbpassword", "", 30);?></TD>
    </tr>

<?php	if ($mode=='advanced') { ?>
    <tr>
     <td width="40%" valign="middle" class="label"><?php echo LABEL_DB_ADMIN_USER ?></td>
     <td><?php textfield ("newsite_dbadmuser", $newsite_dbadmuser, 30);?></td>
	</tr>

	<tr>
     <td width="40%" valign="middle" class="label"><?php echo LABEL_DB_ADMIN_PASSWORD ?></td>
     <td><?php passwordfield ("newsite_dbadmpassword", "", 30);?></td>
    </tr>
<?php	} ?>

   </table>
</fieldset>

<?php	if ( ($mode=='advanced') && is_array($user_classes) ) { ?>
<p>
<fieldset>
 <legend><b><?php echo LABEL_DB_USER_SOURCE ?></b></legend>
   <table border="0" cellspacing="2" cellpadding="2" width="90%">
   <tr>
    <td width="40%" valign='middle' class=label><?php echo LABEL_DB_USER_SOURCE ?></td>
    <td><?php listBox ("newsite_usersource", $user_classes, $newsite_usersource)?></td>
   </tr>
  </TABLE>
</fieldset>
<?php	} ?>

<?php } ?>

<p>
<fieldset>
 <legend><b><?php echo LABEL_FORUMS_CONFIGURATION ?></b></legend>
  <table border="0" cellspacing="2" cellpadding="2" width="90%">

<?php	if ($mode=='advanced') { ?>

   <tr>
    <td width="40%" class=label><?php echo LABEL_FORUM_DIRECTORY?>:</td>
    <td><?php textfield ("newsite_dir_forums", $newsite_dir_forums, 30);?></td>
    </tr>
   <tr>
    <td width="40%" class=label><?php echo LABEL_SEARCH_ENGINE?>:</td>
    <td><?php listbox("newsite_search_engine", $search_engines, $newsite_search_engine);?></td>
   </tr>
<?php	} ?>
   <tr>
    <td width="40%" class=label rowspan=2 valign="top"><?php echo LABEL_DEFAULT_THEME?>:</td>
	<td valign="top"><?php echo $choose_theme_box?><br><br><img src="<?php echo "$tmpl_dir/default/$newsite_theme_dir/screenshot.jpg"?>" height=100 name="screenshot" alt="" align="center"></td>
   </tr>
<?php if ($sf) { ?>
   <tr><td colspan=2><center><br><br>
   <font color=red><?php echo LABEL_NOTICE?>:</font>

   <?php echo NOTICE_SAFEMODE?></center>
   <?php echo NOTICE_MANUAL_INSTALL ?>
   <ul>
   <li> <?php echo $newsite_dir_forums?>
   <li> <?php echo "$newsite_dir_forums/sitename"?>
   <li> <?php echo "$newsite_dir_forums/sitename/default" ?>
   </ul>

   </td></tr>
<?php }?>
  </table>
</fieldset>

<table border="0" cellspacing="2" cellpadding="2" width="90%">
 <tr><td width="70%"> (*) <strong><?php echo LABEL_REQUIRED_FIELD?></strong> </td><td align=right width="70%"><?php submitButton('do_setup', '>> '.LABEL_CREATE_THIS_SITE) ?></td></tr>
 <tr><td colspan=2><small><?php echo LABEL_SITECONF . " : $newmode_url"; ?></td></tr>
</table>


<?php  table_footer() ?>
</form>
</body>
</html>
