<?PHP

/*
 *	W-AGORA 4.1
 *	-----------
 *	$Id: folder.php5,v 1.11 2004/05/24 15:09:40 mdruilhe Exp $
 *	Usage:		include file - Folder/categories/files management functions 
 *	Author:		Marc Druilhe <mdruilhe@w-agora.net>
 */


#	------------------------------------------------------------------
#				Folders functions
#	------------------------------------------------------------------


/**
 * create a folder
 *
 * @param	forum	forum name
 * @param	title	the title of folder
 * @param	desc	the description of folder
 * @param	parent	key of parent folder
 * @access	public
 * @return	integer	0 if OK, negative value if error
 */
function create_folder ($forum, $title, $desc="", $parent=0) {
	global $db, $auth;

	settype ($parent, 'integer');
	$now = time();

# 	Check that parent exists and is a folder and get 'thread id'
#	------------------------------------------------------------
	if ($parent>0) {    
		$result = $db->query ("SELECT thread FROM $forum WHERE cle=$parent AND is_folder=1");
		if (!$db->next_record() ) {
			return ERR_NOTFOUND;
		}
		$thread = $db->f("thread");
	} else {
		$thread = $now;
	}

#	Insert folder
#	-----------
	$fields['is_folder'] = 1;
	
	$fields['userid'] = $auth->user["userid"];
	$fields['username'] = $auth->user["username"];
	$fields['useraddress'] = $auth->user["useraddress"];
	$fields['password'] = $auth->user["password"];

	$fields['cle'] = $now;
	$fields['thread'] = $thread;
	$fields['parent'] = (int)$parent;
	$fields['childs'] = 0;
	$fields['unixdate'] = $now;
	$fields['mod_date'] = $now;
	$fields["newest"] = $now;
	$fields['subject'] = $title;
	$fields['summary'] = $desc;
	$fields['body'] = $desc;
	$fields['hidden'] = 0;

	$rc = $db->insertRow ($forum, $fields);
	if ($rc != 0) {
		return $rc;
	}

#	Update parent folder
#	--------------------
	if ($parent>0) {
		$result = $db->query ("UPDATE $forum SET childs=childs+1 WHERE cle=$parent");
		if (!$result) {
			return ERR_ACCESS;
		}    
	}

	return $now;
}

/**
 * returns the folder contents (description fields)
 *
 * @param	forum	forum name
 * @param	folder	key of folder
 * @access	public
 * @return	array	array populated with folder description
 */
function get_folder ($forum, $folder) {
	global $db;

	settype ($parent, 'integer');
	$cols = 'cle,thread,parent,unixdate,newest,childs,userid,username,useraddress,subject,summary';
	$result = $db->query ("SELECT $cols FROM $forum WHERE cle=$folder AND is_folder=1");
	if (!$db->next_record() ) {
		return ERR_NOTFOUND;
	}

	return $db->Record;
}

/**
 * delete a folder
 *
 * @param	forum	forum name
 * @param	cle		key of folder
 * @access	public
 * @return	integer	0 if OK, negative value if error
 */
function delete_folder ($forum, $key) {
	global $db;

# 	Check that key exists and is a folder and get 'number of childs'
#	----------------------------------------------------------------
	$result = $db->query ("SELECT parent,childs FROM $forum WHERE cle=$key AND is_folder=1");
	if (!$db->next_record() ) {
		return ERR_NOTFOUND;
	}

	$parent = (int) $db->f("parent");
	$childs = (int) $db->f("childs");
	if ($childs>0) {
		return -6;	// not empty   
	}

	$result = $db->query("DELETE FROM $forum WHERE cle=$key");
	if (!$result) {
		return $rc;
	}
 
#	Update parent folder
#	--------------------
	if ($parent>0) {    
		$result = $db->query ("UPDATE $forum SET childs=childs-1 WHERE cle=$parent");
		if (!$result) {
			return ERR_ACCESS;
		}
	}

	return 1;
}

/**
 * get total file count in a given folder (including all sub-folders)
 *
 * @param	forum	forum name
 * @param	folder	key of folder
 * @access	private
 * @return	integer	# of files (negative value if error)
 */
function get_filecount ($forum, $folder) {
	global $db;

	$cnt = 0;

	// count files in current folder
	$result = $db->query ("SELECT count(cle) AS cnt FROM $forum WHERE parent=$folder AND is_folder!=1");
	if ($db->next_record() ) {
		$cnt = (int)$db->f('cnt');
	}

	// get sub-directories
	$result = $db->query ("SELECT cle FROM $forum WHERE parent=$folder AND is_folder=1");
	while ($db->next_record()) {
		$folders[] = $db->f('cle');
	}

	if (is_array($folders)) {
		reset($folders);
		while ( list(,$folder) = each($folders) ) {
			$cnt += get_filecount ($forum, $folder);
		}
	}

	return $cnt;
}

/**
 * get all immediate folders at a given level 
 *
 * @param	forum	forum name
 * @param	parent	key of parent folder
 * @access	public
 * @return	array	array populated with all folders
 */
function get_folders ($forum, $parent=0, $sort="") {
	global $db;

	settype ($parent, 'integer');
	$cols = 'cle,thread,unixdate,newest,childs,subject,summary';

	$order = (empty($sort)) ? "ORDER BY subject" : "ORDER BY $sort";

	$result = $db->query ("SELECT $cols FROM $forum WHERE parent=$parent AND is_folder=1 $order");
	while ($db->next_record()) {
		$cle = $db->f('cle');
		$folders[$cle] = $db->Record;
	}

	if (!is_array($folders) ) {
	    return -1;
	}

	reset($folders);
	while ( list($folder) = each($folders) ) {
		$folders[$folder]['att_count'] = get_filecount ($forum, $folder);
	}

	return $folders;
}

/**
 * returns the clickable path (tree) of the given folder
 *
 * @param	forum	forum name
 * @param	folder	key of folder
 * @param	separator	The separator use to separate each level
 * @access	public
 * @return	string	The path 
 */
function get_folder_path ($forum, $folder, $separator=' &gt; ') {
	global $db, $ext;

	settype ($parent, 'integer');

	$result = $db->query ("SELECT parent, subject FROM $forum WHERE cle=$folder AND is_folder=1");
	if ($db->next_record() ) {
		$path = "<a href=\"modules.$ext?mod=fm&file=list_folder&bn=$forum&folder=$folder\" class=\"wa_link\">".$db->f('subject')."</a>";
		$parent = $db->f('parent');
	}
	
	while ($parent>0) {
		$result = $db->query ("SELECT parent, subject FROM $forum WHERE cle=$parent AND is_folder=1");
		if ($db->next_record() ) {
			$url = "<a href=\"modules.$ext?mod=fm&file=list_folder&bn=$forum&folder=$parent\" class=\"wa_link\">".$db->f('subject')."</a>";
			$parent = $db->f('parent');
			$path =  $url . $separator . $path;
		} else {
		    $parent = 0;
		}
	}
	return $path;
}


#	------------------------------------------------------------------
#				Files functions
#	------------------------------------------------------------------

/**
 * delete a file and all associated comments
 *
 * @param	forum	forum name
 * @param	cle		key of document (note)
 * @access	public
 * @return	integer	0 if OK, negative value if error
 */
function delete_file ($forum, $key) {
	global $db, $site, $bn_dir_notes;

# 	Check that key exists, that is not a folder and get parent folder
#	----------------------------------------------------------------
	$result = $db->query ("SELECT cle, parent, filename FROM $forum WHERE cle=$key AND is_folder!=1");
	if (!$db->next_record() ) {
		return ERR_NOTFOUND;
	}

	$parent = (int) $db->f("parent");
	$filename = (int) $db->f("filename");
	if ($childs>0) {
		return -6;	// not empty   
	}

# 	Delete all associated comments
#	----------------------------
	$result = $db->query ("DELETE FROM $forum WHERE parent=$key");
	if (!$result) {
		return ERR_ACCESS;
	}

# remove HTML file (static mode)
# ------------------------------
	if (!empty($filename) && ($filename != "none") && is_file("$bn_dir_notes/$filename")) {
 		@unlink ("$bn_dir_notes/$filename");
	}

# Remove attachment(s)
# --------------------
	$db->deleteAttachment ($forum, $key, $bn_dir_notes);

# remove document itself
# ----------------------
	$result = $db->query ("DELETE FROM $forum WHERE cle=$key");
	if (!$result) {
		return ERR_ACCESS;
	}

# Update parent folder
# --------------------
	if ($parent>0) {    
		$result = $db->query ("UPDATE $forum SET childs=childs-1 WHERE cle=$parent");
		if (!$result) {
			return ERR_ACCESS;
		}
	}

# Update statistics
# -----------------
	$db->updateForumStats ($site, $forum);

	return 1;
}

/**
 * get all files from the given folder
 *
 * @param	forum	forum name
 * @param	folder	key of folder
 * @access	public
 * @return	array	array populated with all files
 */
function get_files ($forum, $folder=0, $sort='', $start=0, $limit=0) {
	global $db;

	settype ($folder, 'integer');
	settype ($start, 'integer');
	settype ($limit, 'integer');

	if ( ($start>0) || ($limit>0) ) {
		$qlimit = "LIMIT $start, $limit";
	}

	$qorder = (empty($sort)) ? "ORDER BY subject" : "ORDER BY $sort";

	$count=0;
	$result = $db->query ("SELECT * FROM $forum WHERE parent=$folder AND is_folder!=1 $qlimit $qorder");
	while ($db->next_record()) {
		$key = $db->f('cle');
		$db->entries[$key] = $db->Record;
		$db->entries[$key]['parent'] = 0;	// in order to display list as if it was at top level
		$db->entries[$key]['replies'] = $db->entries[$key]['childs'];
		$db->children[0][$count] = $key;
		$count++;
	}

	return $count;
}

/**
 * returns the full URL of a given object
 *
 * The funstion checks if the objet is a folder or a file and return the according URL
 * @param	forum	forum name
 * @param	key		key of the given object
 * @access	public
 * @return	string	The URL 
 */
function get_file_name ($forum, $key) {
	global $db, $ext;

	$name = "";
	$result = $db->query ("SELECT is_folder, subject, parent FROM $forum WHERE cle=$key");
	if ($db->next_record() ) {
		$is_folder = $db->f('is_folder');
		$subject = $db->f('subject');
		$parent = $db->f('parent');
		if (empty($is_folder)) {
		    $name = "<a href=\"modules.$ext?mod=fm&file=view_file&bn=$forum&key=$key&folder=$parent\">$subject</a>";
		}else {
		    $name = "<a href=\"modules.$ext?mod=fm&file=list_folder&bn=$forum&folder=$key\">$subject</a>";
		}
	}

	return $name;
}


#	------------------------------------------------------------------
#				Initialization 
#	------------------------------------------------------------------
	if (!empty($folder)) {
	    $f = get_folder($bn, $folder);
		extract ($f, EXTR_PREFIX_ALL, 'folder');
		unset ($f);
		$folder_path = get_folder_path ($bn, $folder);
		$file_name = (($bn_action == "view_file") || ($bn_action == "edit") || ($bn_action == "delete_file"))? get_file_name($bn, $key): get_file_name($bn, $folder);
	} else {
		$folder_subject = $bn_title;
		$folder_path = "";
		$file_name = (($bn_action == "view_file") || ($bn_action == "edit") || ($bn_action == "delete_file"))? get_file_name($bn, $key) : "<a href='index.$ext?site=$site'>$site_title</a>";
	}


?>
