<?php

/*
 * W-AGORA 4.1
 * -----------
 * $Id: mail_subscribed_users.php5,v 1.3 2004/01/14 21:13:45 mdruilhe Exp $
 * Usage:	Send email to subscribed users in a forum
 * Authors:	Laurent Aufrre <laurent.aufrere@free.fr>
 *			Marc Druilhe <mdruilhe@w-agora.net>
 *
 */

	require ("init_admin.inc");

# Load site administration configuration
# --------------------------------------
	require ("$site_cfg_file");
	if (empty($bn_msgs) ) {
		include ("$bn_dir_default/site_msgs.$ext");
	} else {
		include "$bn_dir/$bn_msgs";
	}

	require ("$inc_dir/mail.$ext");

# Include mail template
# ---------------------
	if (empty($bn_mail_template) ) {
		include ("$bn_dir_default/mail_template.$ext");
	} else {
		include "$bn_dir/$bn_mail_template";
	}

# Displays Header
# ---------------
	display_header (LABEL_SEND_FORUM_SUBSCRIBED_EMAIL . " $forum_name");

# Grab the "active" users out of the database
# -------------------------------------------
	$numusers=0;
	$users = $db->getSubscribedUsers ($site, $bn, 0);
	$userlist = array();
	if (is_array($users) ) {
		reset($users);
		while (list(,$user) = each ($users) ) {
			$userlist[$user] = $user;
		}
	}

	if (count($userlist) < 1) {
		msgWarning (LABEL_NO_SUBSCRIBED_USERS);
		exit;
	}

# send Message if FORM has been filled
# ------------------------------------
	if (isset($sendmail) ) {
		$html = "<P>";

		$numusers=0;

		if (!empty($sendtoall)  ) {

			// send to ALL users
			reset($users);
			while (list(,$user) = each ($users) ) {
				$numusers++;
				$recipients[] = $user;
				$html .= '&nbsp;&nbsp;' . sprintf(LABEL_USER_MAILED, $user, $user);
			}
		} elseif (is_array($form_users)) {

			// send to selected users
			reset($form_users);
			while (list(,$useraddress) = each ($form_users) ) {
				$numusers++;
				$recipients[] = $useraddress;
				$html .= '&nbsp;&nbsp;' . sprintf(LABEL_USER_MAILED, $useraddress, $useraddress);
			}
		}

		$html .= "";

		if (is_array($recipients) ) {
			$html .=  '<br><br>&nbsp;&nbsp;' . sprintf(LABEL_MAIL_USERS, $numusers) . '<br>';
			mail_users ($recipients, $msgsubject, $msgbody, $mail_from, $reply_to, $priority);
		}
		print $html . '<br>';
	}	


# Displays FORM
# -------------
	$mail_from = (isset($mail_from)) ? $mail_from : "$bn_mail_from";
	$reply_to = (isset($reply_to)) ? $reply_to : "$bn_reply_to";
	$msgsubject = (isset($msgsubject)) ? $msgsubject : "";
	$msgbody = (isset($msgbody)) ? $msgbody : "";


	table_header (LABEL_MAIL_FILL_FORM);
	beginForm();

?>
<table width="95%" border=0>
<tr>
  <td width=75><b>Priority:</b></td>
  <td><select name="priority">
      <option value="1">highest</option>
      <option value="2">high</option>
      <option value="3" selected>normal</option>
      <option value="4">low</option>
      <option value="5">lowest</option>
      </select>
  </td>
</tr>
<tr>
  <td width=100 class=label><?php echo COLUMN_TO ?></td>
  <td>
<?php
	listBox('form_users', $userlist, '', 1);
	echo '<br>'.checkBox('sendtoall', 1, $sendtoall, LABEL_SEND_TO_ALL);
?>
  </td>
</tr>

<tr>
  <td width=100 class=label><?php echo COLUMN_FROM ?></td>
  <td><input type="text" name="mail_from" size=60 value="<?php echo $mail_from?>" maxlength=100></td>
</tr>
<tr>
  <td width=100 class=label><?php echo COLUMN_REPLY_TO ?></td>
  <td><input type="text" name="reply_to" size=60 value="<?php echo $reply_to?>" maxlength=100></td>
</tr>
<tr>
  <td width=100 class=label><?php echo COLUMN_SUBJECT ?></td>
  <td><input type="text" name="msgsubject" size=60 value="<?php echo $msgsubject?>" maxlength=255></td>
</tr>
<tr>
  <td width=100 valign="top" class=label><?php echo COLUMN_MESSAGE ?></td>
  <td><textarea name="msgbody" rows=10 cols=60 wrap=virtual><?php echo $msgbody?></textarea></td>
</tr>
<tr><td align=center colspan=2>
 <hr noshade width="90%">
 <input type=submit name="sendmail" value="<?php echo LABEL_SEND_MAIL ?>">
 <input type="reset">
</td></tr>
</table>
<?PHP
	endForm();
	table_footer();
?>
</BODY>
</HTML>
