<?php

/* 
 *	W-AGORA 4.0
 *	-----------
 *	$Id: upgrade_412.php5,v 1.4 2005/06/10 21:53:01 mdruilhe Exp $
 *	Usage:		Upgrade all installations from 4.1.x to 4.1.2
 *	Author:		Marc Druilhe <mdruilhe@w-agora.net>
 */

# Define globals
# --------------

	$agora_dir = "..";

	function updateSite ($site) {
		global $db, $tmpl_dir, $ext;

		$hoe = $db->setHaltOnError('report');

		// drop unused fields in USERS table
		// ---------------------------------
		echo ("<li> <I>altering table</I> <B>${site}_users</B>");
		$db->query ("alter table ${site}_users drop cle");
		$db->query ("alter table ${site}_users drop parent");
		$db->query ("alter table ${site}_users drop childs");
		$db->query ("alter table ${site}_users drop thread");
		$db->query ("alter table ${site}_users drop newest");

		$db->query ("alter table ${site}_users ADD primary key (userid)");

		// Update attachment size in forums table
		// --------------------------------------
		echo ("<li> <I>Update attachments size in forum tables</I>");
		$query = "select bn_name, note_id, sum(att_size) as att_size from ${site}_attachments GROUP BY bn_name, note_id";
		$db->query ($query);
		$attachments =array();
		$i=0;
		while ($db->next_record() ) {
			$attachments[$i++] = $db->Record;
		}

		if (count($attachments)>0) {
			reset($attachments);
			while (list(,$rec)= each($attachments) ) {
				$query = 'UPDATE '.$rec['bn_name'].' SET att_size='.$rec['att_size'].' WHERE cle='.$rec['note_id'];
				echo "<br>$query";
				$db->query ($query);
			}
		}

		// Update attachments inline flag
		// ------------------------------
		echo ("<li> <I>Update attachments inline flag (attachments table) </I>");
		$query = "UPDATE ${site}_attachments SET inline='1' WHERE inline=''";
		$db->query ($query);

		$db->setHaltOnError($hoe);
	}


	chdir ("$agora_dir");

	$site = "agora";
	include ("init_admin.inc");

?>
<html>
<head>
<style type="text/css">
<!-- 
body { font-size: 9pt  font-family: Helvetica, Arial, Geneva; }
-->
</style>
</head><body><H3>Upgrading w-agora from version 4.1.x to 4.1.2</H3>
<?php 

# Load default messages
# ---------------------
	include "$tmpl_dir/default/agora/msgs.$ext";
	$new_msg = $msg;
	unset ($msg);

	// drop unused fields in USERS table
	// ---------------------------------
	echo ("<li> <I>altering table</I> <B>agora_users</B>");
	$hoe = $db->setHaltOnError('report');
	$db->query ("alter table agora_users drop cle");
	$db->query ("alter table agora_users drop parent");
	$db->query ("alter table agora_users drop childs");
	$db->query ("alter table agora_users drop thread");
	$db->query ("alter table agora_users drop newest");
	$db->setHaltOnError($hoe);

# gets all configured sites
# -------------------------
	$db->query ("select bn_name, bn_title from agora");
	while ($db->next_record() ) {
		$sitename = $db->f("bn_name");
		$sites[$sitename] = $db->f("bn_title");
	}

	$db->closeDB();
	unset ($db);

# loop over all sites
# -------------------
	reset ($sites);
	while (list ($site, $site_title) = each($sites) ) {
		@set_time_limit(30);
		print "<hr><h2>Upgrading site: <B>$site</B> ($site_title)</h2> ";

		// include Site configuration
		if (!is_file ("$cfg_dir/site_${site}.$ext") ) {
			die ("Cannot open file: $cfg_dir/site_${site}.$ext, make sure that site $site really exists");
		}
		include "$cfg_dir/site_${site}.$ext";

		// open new DB connection for this site
		include "$inc_dir/$bn_access.$ext";
		$db_class = "${bn_access}_access";
		$db = new $db_class;
		$db->openDB($dbhost, $dbport, $dbuser, $dbpassword, $dbname, $site);

		// update site
		updateSite($site);

		// close DB connection
		$db->closeDB();
		unset ($db);
		print "</ul>";
	}

?>