//
// Copyright (C) 1999-2002 Toshikaz Hirabayashi
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// TOSHIKAZ HIRABAYASHI BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
// WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF
// OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
// Except as contained in this notice, the name of Toshikaz Hirabayashi shall
// not be used in advertising or otherwise to promote the sale, use or other
// dealings in this Software without prior written authorization from
// Toshikaz Hirabayashi.

#ifndef WSCRBASE_H
#define WSCRBASE_H

#include <WScom.h>
#include <WSCRroot.h>
#include <WSCstring.h>
#include <WSDserialize.h>
#include <WSCconductor.h>
#include <WSCindexData.h>

class WSCRbase :public WSCRroot{

 protected:
  WSCbase* _local;
static WSCindexData* _create_handlers;

 public:
  WSCRbase();
  virtual ~WSCRbase();
  void setLocalInstance(WSCbase*);

static  void setCreateHandler(char* cn,WSCRbase* (*hd)());
static  WSCRbase* getNewInstance(char* cn);

  void    setVisible(WSCbool fl);
  WSCbool getVisible();
  void    setSensitive(WSCbool fl);
  WSCbool getSensitive();

  long clear();
  long draw();
  long redraw();
  long cdraw();

  void onMouseIn(WSCpoint*);
  void onMouseOut();
  void onMouseMove(WSCpoint*);
  void onMousePress(WSCpoint*);
  void onMouseRelease(WSCpoint*);
  void onExpose(WSCrect*);
  void onResize(WSCrect*);
  void onVisibleChange(WSCbool);
  void onSensitiveChange(WSCbool);
  void onParentVisibleChange(WSCbool);
  void onParentSensitiveChange(WSCbool);
  void onEditModeChange(WSCbool);
  void onFocusChange(WSCbool);
  void onSpecialFocusChange(WSCbool);
  void onSelectionChange(WSCbool);

  void execProcedure(char*);
  void execProcedure(long);

  WSCbool    setProperty(char *name,const WSCvariant&);
  WSCvariant getProperty(char* name);

  WSCbool getFocus();
  WSCbool getSpecialFocus();
  long setFocus(WSCbool fl = True);
  long setSpecialFocus(WSCbool fl = True);

  WSMFclassDef(WSCRbase,WSCRroot);
};

#define WSMFremoteClassInit(RCN,CN) \
  WSCRbase* RCN ## _create(){ \
    return new RCN(); \
  };\
  class RCN ## _init{ \
    public: \
      RCN ## _init(){ \
        WSCRbase::setCreateHandler(#CN,RCN ## _create ); \
      }; \
  }; \
  static RCN ## _init RCN ## _init_run_constructor;

#endif
