<?php

/*
 *	W-AGORA 4.0
 *	-----------
 *	$Id: delete.php5,v 1.23 2005/02/10 14:14:27 mdruilhe Exp $
 *	Usage:		Delete note in forum
 *	Author:		Marc Druilhe <mdruilhe@w-agora.com>
 *
 */

# initialization stuff
# --------------------
 	$bn_action="delete";
	$bn_action_mode="W";
	include "init.inc";

	settype($key, "integer");

# if note to delete is not defined then return to the list
# --------------------------------------------------------
	if (empty($key)) {
		if (!empty($before_access)) include $before_access;
		display_header (LABEL_DELETE_NOTE, $header_footer);
		MsgForm (ERROR_SPECIFY_KEY, "list.$ext", "");
		display_footer ($header_footer);
	}

# Check that the "allow delete" option is set on this forum
# If it is not, then only the moderator of this board can delete a message
# ------------------------------------------------------------------------
	if (!$bn_delete && !$is_moderator) {
		if (!empty($before_access)) include $before_access;
		display_header (LABEL_DELETE_NOTE, $header_footer);
		MsgForm (ERROR_FORBIDDEN_ACCESS, "view.$ext?key=$key", "");
		display_footer ($header_footer);
	}

# read note in order to insure that this note exists and to get userid/password of the owner
# ---------------------------------------------------------------------------------------
	$note = $db->getNote ($bn_db, $key);
	if (!is_array($note) ) {
		if (!empty($before_access)) include $before_access;
		display_header (LABEL_DELETE_NOTE, $header_footer);
		MsgForm (sprintf(ERROR_NOTE_NOT_FOUND, $msg[0]), "list.$ext", "");
		display_footer ($header_footer);
	}

# If this message has replies, do not allow the user to delete it
# ---------------------------------------------------------------
	if ( ($childs>0) && !$is_moderator) {
		if (!empty($before_access)) include $before_access;
		display_header (LABEL_DELETE_NOTE, $header_footer);
		MsgForm (ERROR_FORBIDDEN_ACCESS, "view.$ext?key=$key", "");
		display_footer ($header_footer);
	}

# Check that we are either a moderator or the original poster of this note
# ------------------------------------------------------------------------
	if (!$is_authenticated) {
		if ($note["userid"] == 'guest') {
			$is_owner = false;
	} else {
			$loginURL = $auth->getLoginURL();
			if (is_string($loginURL)) {
				header("Location: $loginURL");
			} else {
				if (!empty($before_access)) include $before_access;
				display_header ('login', $header_footer);
				$auth->login($site, LABEL_MUST_LOGIN);
				display_footer ($header_footer);
			}
			exit;
		}
	} elseif ($is_moderator) {
		// a moderator can edit/delete a post
		$is_owner=true;
	} elseif ($auth->user["userid"] == $note["userid"]) {
		// the note was posted by this authenticated user
		$is_owner = true;
	} elseif ($note["userid"] == 'guest') {
		// This note has been posted by a guest user => check password
		$is_owner = ($auth->user["password"] == $note["password"]) ? true : false;
		} else {
		// The user is authenticated but this note was posted by another user
		if (!empty($before_access)) include $before_access;
		display_header (TITLE_ERROR, $header_footer);
		MsgForm (ERROR_FORBIDDEN_ACCESS, "view.$ext?key=$key", 'close'); // access forbidden
		display_footer ($header_footer);
		exit;
	} 

# ----------------------------------------------
# delete FORM has been submitted -> do the stuff
# ----------------------------------------------
	if ($do_delete) {
		
# Execute before_access program
# ------------------------------
		if (!empty($before_access)) include $before_access;

		display_header (LABEL_DELETE_NOTE, $header_footer);

# Check that either this user is owner of this note or has entered the password
# -----------------------------------------------------------------------------
		if (!$is_owner && (md5($password) != $note["password"])) {
			MsgForm (ERROR_INVALID_PASSWORD, "view.$ext?key=$key", 'back'); // invalid password
			display_footer ($header_footer);
		}

# delete the note from the database
# ---------------------------------
		$ret = $db->deleteNote ($bn_db, $key, $bn_dir_notes);
		if ($ret < 0) {
			MsgForm (sprintf(ERROR_DATABASE, $ret), "list.$ext?bn=$bn", "");
			display_footer ($header_footer);
		}

# Start search indexation if a search engine is configured
# --------------------------------------------------------
		if ($bn_search && ($bn_doc_type == "static") && ($bn_search_engine != "none") ) {
			include "$inc_dir/$bn_search_engine.$ext";
			$search->indexNotes();
		}

# Displays success message then exit
# ----------------------------------
		MsgForm (sprintf(MSG_NOTE_DELETED, $msg[0]), "list.$ext?bn=$bn&expnd=$expnd&sort=$sort&force_refresh=1", "");
		display_footer ($header_footer);
		exit;
	} // do_delete


# ----------------------------------------------------------
# First ACCESS => displays confirmation FORM + displays note
# ----------------------------------------------------------

# do_delete not set => set all fields as global variables
# -------------------------------------------------------
	extract($note);

# Execute before_access program
# ------------------------------
 	$bn_action="view";
	if (!empty($before_access)) include $before_access;

# displays form (OK to delete)
# ----------------------------
	display_header (LABEL_DELETE_NOTE, $header_footer);

	beginForm();
	hiddenField ("key", $key);
	if ($first != $key) {
		hiddenField ("first", $first);
	}
	hiddenField ("expnd", $expnd);
	hiddenField ("do_delete", 1);

	// Ask for confirmation
	echo '<h3>'; printf(LABEL_ASK_DELETE_NOTE, $msg[0]); echo '</h3><br>';

# in case of public forum, ask for password (if authenticated user is not the
# original poster)
# ----------------------------------------------------------------------------
	if (!$is_owner) {
		print LABEL_USER_PASSWORD; // password
		passwordField ("password", "", 10);
		br();
	}
	print '<CENTER>';
	submitButton ('do_delete', BUTTON_DELETE);
	backButton ('', BUTTON_BACK );
	print '</CENTER><hr size=2>';
	endForm();


# displays note
# -------------
	$viewkey = $key;
	include "$inc_dir/viewnote.$ext";

# Display footer
# --------------
	display_footer ($header_footer);
?>
