<?php

/*
 *	W-AGORA 4.0
 *	-----------
 *	$Id: forgot_password.php5,v 1.18 2005/03/11 11:39:03 mdruilhe Exp $
 *	Usage:		Generate a new password if lost
 *	Authors:	Jeff Haug <jeff@hozt.com>
 *				Marc Druilhe <mdruilhe@w-agora.net> 
 *
 */

$no_cookie=1;
define("no_auth_required", 1);
$bn_action="forgot_password";

require ("init.inc");

# Send to forgot password page if defined
# --------------------------------
$newURL = $auth->getForgotPasswordURL();
if (is_string($newURL)) {
	if (empty($newURL)) {
		if (!empty($before_access)) include $before_access;
		display_header (LABEL_FORGOT_PASSWORD, $header_footer);
		msgForm (ERROR_FEATURE_DISABLED, "$WA_SELF", "back");
		display_footer ($header_footer);
	} else {
		header("Location: $newURL");
	}
	exit;
}

# Execute before_access program
# -----------------------------
if (!empty($before_access)) include $before_access;

display_header (LABEL_FORGOT_PASSWORD, $header_footer);

# If Creation form have been submitted
# ------------------------------------
if (isset($go)) {

	$go=0;

#	Check for required fields
#	-------------------------
	if (empty ($userid)) {
		MsgForm (ERROR_MISSING_USERID, $WA_SELF, 'back');
		display_footer ($header_footer);
		exit;
	}

	if ($userid == "admin") {
		MsgForm (ERROR_NO_ADMIN_PASSWORD_CHANGE, $WA_SELF, 'back');
		display_footer ($header_footer);
		exit;
	}

#	get userid / password
#	-----------------------
	$userid = htmlentities($userid);
	$u = $db->getUser($site, $userid);
	if (!is_array ($u) ) {
		msgForm (sprintf(ERROR_USERID_NOT_FOUND, $userid), $WA_SELF, 'back');
		display_footer ($header_footer);
		exit;
	}

#  Update password for this user in the users table
#  ------------------------------------------------
	$passwd = $auth->genPassword();
	$u_fields["password"] = md5($passwd);
	$ret = $db->updateUser ($site, $userid, $u_fields);
	 
	if ($ret < 0) {
		msgForm (sprintf(ERROR_NO_PASSWORD_CHANGE, $userid), $WA_SELF, 'back');
		display_footer ($header_footer);
		exit;
	}

# now send password to the address of this user
# ---------------------------------------------
	include "$inc_dir/mail.$ext";
	mail_password ($userid, $passwd, $u["useraddress"]);

	msgForm (MSG_NEW_PASSWORD_SENT, "$main_page?site=$site", "", "_top");
	display_footer ($header_footer);

	exit;
}

#  -------------------------------------------
#  Initialize default values then display FORM
#  -------------------------------------------

	$userid = (isset($userid)) ? $userid : "";
	$form_title = TITLE_FORGOT_PASSWORD_FORM;
	$submit_button = '<INPUT TYPE="submit" VALUE="'. BUTTON_SEND_PASSWORD . '" />';

	$input_userid = getTextField ('userid', '', 32, 32);
	$change_password_url = "change_password.$ext?site=$site&bn=$bn&userid=$userid";
	$forgot_password_url = "forgot_password.$ext?site=$site&bn=$bn";

	beginForm();
	hiddenField ("go", "1");
	if (!empty($bn_forgot_form) && file_exists("${bn_dir}/${bn_forgot_form}") ) {
		include "${bn_dir}/${bn_forgot_form}";
	} elseif ( file_exists("${bn_dir_default}/forgot_password_form.$ext") ) {
		include "${bn_dir_default}/forgot_password_form.$ext";
	} else {
		include "${tmpl_dir}/default/agora/forgot_password_form.$ext";
	}
	endForm();
	display_footer ($header_footer);
?>
