/*
   +----------------------------------------------------------------------+
   | Hardening Patch for PHP                                              |
   +----------------------------------------------------------------------+
   | Copyright (c) 2004-2005 Stefan Esser                                 |
   +----------------------------------------------------------------------+
   | This source file is subject to version 2.02 of the PHP license,      |
   | that is bundled with this package in the file LICENSE, and is        |
   | available at through the world-wide-web at                           |
   | http://www.php.net/license/2_02.txt.                                 |
   | If you did not receive a copy of the PHP license and are unable to   |
   | obtain it through the world-wide-web, please send a note to          |
   | license@php.net so we can mail you a copy immediately.               |
   +----------------------------------------------------------------------+
   | Author: Stefan Esser <sesser@hardened-php.net>                       |
   +----------------------------------------------------------------------+
 */

#ifndef HARDENING_PATCH_H
#define HARDENING_PATCH_H

#include "zend.h"

#if HARDENING_PATCH
PHPAPI void php_security_log(int loglevel, char *fmt, ...);
PHPAPI void hardened_startup();
#define HARDENING_PATCH_VERSION "0.4.15"

#endif

#if HARDENING_PATCH_MM_PROTECT || HARDENING_PATCH_LL_PROTECT || HARDENING_PATCH_HASH_PROTECT
PHPAPI unsigned int php_canary();
#endif

#if HARDENING_PATCH_INC_PROTECT
PHPAPI int php_is_valid_include(zval *z);
#endif

#endif /* HARDENING_PATCH_H */

/*
 * Local variables:
 * tab-width: 4
 * c-basic-offset: 4
 * End:
 */
