#!/bin/bash
# doxygen
#	BuildScript for Plamo Linux 4.6
#			by Jun Kuwamura <juk@linet.gr.jp> on 2009-07-04
# require:
#
SRC_URI=http://ftp.stack.nl/pub/users/dimitri/doxygen-1.5.9.src.tar.gz
SRC_FILE=${SRC_URI##*/}
PAC_NAME=${SRC_FILE%%.src.tar.gz}
VERSION=${PAC_NAME##*-}

REL=P1
CPU=i586
SYS_NAME="${CPU}-${REL}"

PLAMO=/expo/Build
SRC_DIR=$PLAMO/Archive/text
PAC_DIR=$PLAMO/Packages/4.6/03_ext
BUILD_DIR=$PLAMO/doxygen
CUSTOM_DIR=$BUILD_DIR/Custom
PAT_FILE=

echo $PAC_DIR
if [ ! -d $PAC_DIR ]; then
  mkdir -p  $PAC_DIR
fi
echo $SRC_DIR/$SRC_FILE
if [ ! -f $SRC_DIR/$SRC_FILE ]; then
  if [ ! -d $SRC_DIR ]; then
    mkdir -p $SRC_DIR
  fi
  ( cd $SRC_DIR; wget $SRC_URI )
fi


umask 022
CWD=`pwd`
WORK=$CWD/work
rm -rf $WORK/*
mkdir -p $WORK
export LANG=C
export LC_ALL=C
export CFLAGS="-O2 -march=$CPU"
export PATH=$PATH:/usr/X11R7/bin:/opt/teTeX/bin


tar xvfz $SRC_DIR/$SRC_FILE
cd $PAC_NAME
if [ -f "$PAT_FILE" ]; then
  patch < $PAT_FILE
fi
./configure --prefix /usr
make
make docs
make install DESTDIR=$WORK
make install_docs DESTDIR=$WORK


DOC_DIR=$WORK/usr/share/doc/$PAC_NAME
mv $WORK/usr/share/doc/packages/doxygen $DOC_DIR
rmdir $WORK/usr/share/doc/packages
#mkdir -p $DOC_DIR
cp -p $BUILD_DIR/`basename $0`  \
    Doxyfile INSTALL LANGUAGE.HOWTO LICENSE PLATFORMS README VERSION  \
    $DOC_DIR
chown -R root.root $DOC_DIR
chmod -R a+rX $DOC_DIR

cd $WORK
echo "y
" | makepkg ${PAC_NAME}.tgz

echo -n "$PAC_DIR/${PAC_NAME}-${SYS_NAME}.tgz"
if `mv -v ${PAC_NAME}.tgz  $PAC_DIR/${PAC_NAME}-${SYS_NAME}.tgz 1>/dev/null 2>&1`; then
  echo " ... done"
else
  echo " ... false"
fi

cd $CWD
