/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.security.x509;

import java.security.cert.PolicyNode;
import java.security.cert.PolicyQualifierInfo;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public final class PolicyNodeImpl
implements PolicyNode {
    private String policy;
    private final Set expectedPolicies = new HashSet();
    private final Set qualifiers = new HashSet();
    private final Set children = new HashSet();
    private PolicyNodeImpl parent;
    private int depth;
    private boolean critical = false;
    private boolean readOnly = false;

    public void addChild(PolicyNodeImpl node2) {
        if (this.readOnly) {
            throw new IllegalStateException("read only");
        }
        if (node2.getParent() != null) {
            throw new IllegalStateException("already a child node");
        }
        node2.parent = this;
        node2.setDepth(this.depth + 1);
        this.children.add(node2);
    }

    public Iterator getChildren() {
        return Collections.unmodifiableSet(this.children).iterator();
    }

    public int getDepth() {
        return this.depth;
    }

    public void setDepth(int depth) {
        if (this.readOnly) {
            throw new IllegalStateException("read only");
        }
        this.depth = depth;
    }

    public void addAllExpectedPolicies(Set policies) {
        if (this.readOnly) {
            throw new IllegalStateException("read only");
        }
        this.expectedPolicies.addAll(policies);
    }

    public void addExpectedPolicy(String policy) {
        if (this.readOnly) {
            throw new IllegalStateException("read only");
        }
        this.expectedPolicies.add(policy);
    }

    public Set getExpectedPolicies() {
        return Collections.unmodifiableSet(this.expectedPolicies);
    }

    public PolicyNode getParent() {
        return this.parent;
    }

    public void addAllPolicyQualifiers(Collection qualifiers) {
        Iterator it = qualifiers.iterator();
        while (it.hasNext()) {
            if (it.next() instanceof PolicyQualifierInfo) continue;
            throw new IllegalArgumentException("can only add PolicyQualifierInfos");
        }
        qualifiers.addAll(qualifiers);
    }

    public void addPolicyQualifier(PolicyQualifierInfo qualifier) {
        if (this.readOnly) {
            throw new IllegalStateException("read only");
        }
        this.qualifiers.add(qualifier);
    }

    public Set getPolicyQualifiers() {
        return Collections.unmodifiableSet(this.qualifiers);
    }

    public String getValidPolicy() {
        return this.policy;
    }

    public void setValidPolicy(String policy) {
        if (this.readOnly) {
            throw new IllegalStateException("read only");
        }
        this.policy = policy;
    }

    public boolean isCritical() {
        return this.critical;
    }

    public void setCritical(boolean critical) {
        if (this.readOnly) {
            throw new IllegalStateException("read only");
        }
        this.critical = critical;
    }

    public void setReadOnly() {
        if (this.readOnly) {
            return;
        }
        this.readOnly = true;
        Iterator it = this.getChildren();
        while (it.hasNext()) {
            ((PolicyNodeImpl)it.next()).setReadOnly();
        }
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < this.depth) {
            buf.append("  ");
            ++i;
        }
        buf.append("(");
        buf.append(PolicyNodeImpl.class.getName());
        buf.append(" (oid ");
        buf.append(this.policy);
        buf.append(") (depth ");
        buf.append(this.depth);
        buf.append(") (qualifiers ");
        buf.append(this.qualifiers);
        buf.append(") (critical ");
        buf.append(this.critical);
        buf.append(") (expectedPolicies ");
        buf.append(this.expectedPolicies);
        buf.append(") (children (");
        String nl = System.getProperty("line.separator");
        Iterator it = this.getChildren();
        while (it.hasNext()) {
            buf.append(nl);
            buf.append(it.next().toString());
        }
        buf.append(")))");
        return buf.toString();
    }
}

