/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.util.regex;

import gnu.java.util.regex.CharIndexed;
import gnu.java.util.regex.REException;
import gnu.java.util.regex.REMatch;
import gnu.java.util.regex.REToken;

final class RETokenLookBehind
extends REToken {
    REToken re;
    boolean negative;

    RETokenLookBehind(REToken re, boolean negative) throws REException {
        super(0);
        this.re = re;
        this.negative = negative;
    }

    int getMaximumLength() {
        return 0;
    }

    REMatch matchThis(CharIndexed input, REMatch mymatch) {
        int max = this.re.getMaximumLength();
        CharIndexed behind = input.lookBehind(mymatch.index, max);
        REMatch trymatch = (REMatch)mymatch.clone();
        REMatch cfr_ignored_0 = (REMatch)mymatch.clone();
        int diff = behind.length() - input.length();
        int curIndex = trymatch.index + diff;
        trymatch.index = 0;
        trymatch.offset = 0;
        RETokenMatchHereOnly stopper = new RETokenMatchHereOnly(curIndex);
        REToken re1 = (REToken)this.re.clone();
        re1.chain(stopper);
        if (re1.match(behind, trymatch)) {
            if (this.negative) {
                return null;
            }
            int i = 0;
            while (i < trymatch.start.length) {
                if (trymatch.start[i] != -1 && trymatch.end[i] != -1) {
                    int n = i;
                    trymatch.start[n] = trymatch.start[n] - diff;
                    if (trymatch.start[i] < 0) {
                        int n2 = i;
                        trymatch.start[n2] = trymatch.start[n2] - 1;
                    }
                    int n3 = i;
                    trymatch.end[n3] = trymatch.end[n3] - diff;
                    if (trymatch.end[i] < 0) {
                        int n4 = i;
                        trymatch.end[n4] = trymatch.end[n4] - 1;
                    }
                }
                ++i;
            }
            trymatch.index = mymatch.index;
            trymatch.offset = mymatch.offset;
            return trymatch;
        }
        if (this.negative) {
            return mymatch;
        }
        return null;
    }

    void dump(StringBuffer os) {
        os.append("(?<");
        os.append(this.negative ? (char)'!' : '=');
        this.re.dumpAll(os);
        os.append(')');
    }

    private static class RETokenMatchHereOnly
    extends REToken {
        private int index;

        int getMaximumLength() {
            return 0;
        }

        RETokenMatchHereOnly(int index) {
            super(0);
            this.index = index;
        }

        REMatch matchThis(CharIndexed input, REMatch mymatch) {
            return this.index == mymatch.index ? mymatch : null;
        }

        void dump(StringBuffer os) {
        }
    }
}

