/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.crypto.key.dh;

import gnu.java.security.action.GetPropertyAction;
import gnu.java.security.util.FormatUtil;
import java.math.BigInteger;
import java.security.AccessController;
import java.security.Key;
import javax.crypto.interfaces.DHKey;
import javax.crypto.spec.DHParameterSpec;

public abstract class GnuDHKey
implements Key,
DHKey {
    protected BigInteger q;
    protected BigInteger p;
    protected BigInteger g;
    protected final int defaultFormat;
    private transient String str;

    protected GnuDHKey(int defaultFormat, BigInteger q, BigInteger p, BigInteger g) {
        this.defaultFormat = defaultFormat <= 0 ? 1 : defaultFormat;
        this.q = q;
        this.p = p;
        this.g = g;
    }

    public DHParameterSpec getParams() {
        if (this.q == null) {
            return new DHParameterSpec(this.p, this.g);
        }
        return new DHParameterSpec(this.p, this.g, this.q.bitLength());
    }

    public String getAlgorithm() {
        return "dh";
    }

    public byte[] getEncoded() {
        return this.getEncoded(this.defaultFormat);
    }

    public String getFormat() {
        return FormatUtil.getEncodingShortName(this.defaultFormat);
    }

    public BigInteger getQ() {
        return this.q;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DHKey)) {
            return false;
        }
        DHKey that = (DHKey)obj;
        return this.p.equals(that.getParams().getP()) && this.g.equals(that.getParams().getG());
    }

    public String toString() {
        if (this.str == null) {
            String ls = AccessController.doPrivileged(new GetPropertyAction("line.separator"));
            StringBuilder sb = new StringBuilder(ls).append("defaultFormat=").append(this.defaultFormat).append(",").append(ls);
            if (this.q == null) {
                sb.append("q=null,");
            } else {
                sb.append("q=0x").append(this.q.toString(16)).append(",");
            }
            sb.append(ls).append("p=0x").append(this.p.toString(16)).append(",").append(ls).append("g=0x").append(this.g.toString(16));
            this.str = sb.toString();
        }
        return this.str;
    }

    public abstract byte[] getEncoded(int var1);
}

